uniform float timer;
const float pi = 3.14159265358979323846;

vec4 Process(vec4 color)
{
	vec2 uv = gl_TexCoord[0].st;
	
	vec2 uvCloud = uv * 8.;
	vec2 uvCloudWarp = uvCloud;
	uvCloud.y += timer/8.;
	
	float pi2 = pi;
	
	uvCloudWarp.x += sin(pi2 * (uvCloud.y * 0.75 + timer * 0.1)) * 0.25;
	uvCloudWarp.y += sin(pi2 * (uvCloud.x * 0.75 + timer * 0.1)) * 0.25;
	
	vec4 texDark = texture2D(tex, uv);
	vec4 texCloud = texture2D(tex, uvCloudWarp);
	texCloud = mix(texCloud, vec4(1.0), texture2D(tex, uvCloud).r);
	
	//vec4 texColor = mix(vec4(0.6,0.28,0.92,1.0), vec4(0.14,0.0,0.26,1.0), uv.y);
	vec4 texColor = mix(vec4(0.6,0.28,0.92,1.0), vec4(0.1,0.0,0.2,1.0), uv.y);
	
	vec4 texCombined = mix(vec4(1.0, 1.0, 1.0, 1.0), vec4(texCloud.r, texCloud.r, texCloud.r, 1.0), texDark.g);
	
	vec4 texFinal = mix(vec4(0.0,0.0,0.0,1.0), texColor, texCombined.r);
	texFinal.a = color.a;
	
	return texFinal;
}