uniform float timer;

vec4 Process(vec4 color)
{
	//vec3 quadColor = vec3(0.75,0.0,1.0);
	vec3 quadColor = vec3(1.0,0.25,0.53);
	
	vec2 uv = gl_TexCoord[0].st;
	vec2 uvScroll = vec2(uv.x, mod(uv.y+timer, 1.0));
	
	vec4 baseTex = texture2D(tex, uv);
	vec4 cloudScroll = texture2D(tex, uvScroll);
	float getMix = (0.5+cloudScroll.r/2)-(1.0-baseTex.g);
	getMix = clamp(getMix, 0.0, 1.0)*color.a;
	//vec3 finalColor = mix(vec3(0,0,0), vec3(0.25,0.0,0.75), getMix);
	vec3 finalColor = mix(vec3(0.5,0.0,1.0), quadColor, max(0.0,getMix-0.5)*2);
	return vec4(finalColor, getMix);
}