uniform float timer;
vec4 Process(vec4 color)
{
	vec2 uv = gl_TexCoord[0].st;
	
	vec2 uvWobble = uv - (0.5,0.5);
	uvWobble *= 1.0 + cos(timer*1.5) * 0.1;
	uvWobble += (0.5,0.5);
	
	vec3 lineMix = vec3(0,0,0);
	float blurMix = texture2D(tex, uvWobble).g;
	vec2 warpUV = uv;
	warpUV.x = mod(1.0-warpUV.x, 1.0);
	warpUV.y = mod(1.0-warpUV.y, 1.0);
	warpUV.x += cos((uv.y * 3.14) + timer) * 0.05;
	warpUV.y += sin((uv.x * 3.14) + timer) * 0.05;
	
	for ( int i = 0; i < 2; i++ )
	{
		float baseTimer = (timer+(0.5*i));
		float zoomAmount = mod(baseTimer,1.0);
		float alpha = abs(sin(zoomAmount*3.14));
		vec2 uvNew = uv.xy - vec2(0.5,0.5);
		uvNew *= 1.0 - zoomAmount * 0.75;
		uvNew += vec2(0.5,0.5);
		lineMix = mix(lineMix, vec3(1.0,1.0,1.0), texture2D(tex, uvNew).r*alpha);
		uv = warpUV;
		//warpUV.x = mod(1.0-warpUV.x, 1.0);
		//warpUV.y = mod(1.0-warpUV.y, 1.0);
	}
	
	float getMix = mix(blurMix, lineMix.r, 0.5);
	//lineMix = mix(vec3(1,0,0), vec3(1.0,0.3,0.25), lineMix.r-(1.0-blurMix));
	vec3 finalColor = mix(vec3(1,0,0), vec3(1.0,0.3,0.25), max(0.0,getMix-0.5)*2);
	
	return vec4(finalColor, getMix*color.a);
}