uniform float timer;

const float borderWidthMin = 0.04;
const float borderWidthMax = 0.96;

vec3 hsv2rgb(vec3 c)
{
	vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
	vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
	return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec4 Process(vec4 color)
{
	vec2 uv = gl_TexCoord[0].st;
	vec4 balls = texture2D(tex, uv);
	vec3 borderColor = hsv2rgb(vec3(timer,0.5,1.0));
	float mixer = 0.0;
	if ( uv.x < borderWidthMax && uv.x > borderWidthMin && uv.y < borderWidthMax && uv.y > borderWidthMin )
	{
		mixer = 1.0;
	}
	
	return mix(vec4(borderColor, 1.0), balls, mixer);
}