uniform float timer;

vec4 Process(vec4 color)
{
	#ifndef NO_FOG
		vec2 uv = gl_TexCoord[0].st;
		vec2 texCoord;
		texCoord.x = uv.s / 2;
		texCoord.y = pixelpos.y / 2;
		
		vec2 scrollClouds = texCoord + vec2(0., timer * 48);// timer * 24;
		vec2 scrollGrid1 = texCoord.st + vec2(0., timer * 32);// * 16);
		vec2 scrollGrid2 = texCoord.st + vec2(0.125, timer * 16);// * 2);
		
		vec2 texCoordGridTop = vec2(mod(scrollGrid1.x*256., 256.),
			mod(scrollGrid1.y, 256.));
		vec2 texCoordGridBottom = vec2(mod(scrollGrid2.x*256., 256.),
			mod(scrollGrid2.y, 256.));
			
		vec2 texCoordClouds = vec2(mod(scrollClouds.x*256., 256.),
			mod(scrollClouds.y-256, 256.)+256);
		
		ivec2 texPosGridTop = ivec2(int(texCoordGridTop.x), int(texCoordGridTop.y));
		ivec2 texPosGridBottom = ivec2(int(texCoordGridBottom.x), int(texCoordGridBottom.y));
		ivec2 texPosClouds = ivec2(int(texCoordClouds.x), int(texCoordClouds.y));
		
		vec4 texGridTop = texture2DLod(tex, texPosGridTop.xy / vec2(256.,544.), 0.);
		vec4 texGridBottom = texture2DLod(tex, texPosGridBottom.xy / vec2(256.,544.), 0.);
		vec4 texClouds = texture2DLod(tex, texPosClouds.xy / vec2(256.,544.), 0.);
		
		vec4 waterMix = mix(vec4(1,1,1,0), vec4(0,0,0,0), 1.0-texGridBottom.r);
		waterMix = mix(waterMix, vec4(0,0,0,0), 1.0-texGridTop.r);
		waterMix = mix(waterMix, vec4(0,0,0,0), 1.0-texClouds.r);
		
		vec4 finalMix = waterMix;
		
		finalMix = clamp(finalMix, 0.0, 1.0);
		
		ivec2 texPosRamp = ivec2(int(finalMix.r*255), int(513));
		return texture2DLod(tex, texPosRamp.xy / vec2(256.,544.), 0.) * vec4(0.975,0.975,0.975,1.0);//texelFetch(tex, texPosRamp.xy, 0);
	#else
		return vec4(1.0,1.0,0.0,1.0);
	#endif
}