uniform float timer;

vec4 Process(vec4 color)
{
	//float waterFog = distance(camerapos.xz, pixelpos.xz) / (16834 * 2);
	#ifndef NO_FOG
		float waterFog = pixelpos.w / (16384 / 2);//(16834 * 2);
		vec2 texCoord = pixelpos.xz / 2;
	
		vec4 closeColor = vec4(0,0,0,1);
		vec4 farColor = vec4(1,1,1,1);
		
		vec2 scrollClouds = texCoord / 2;
		vec2 scrollGrid1 = texCoord.st / 2 + vec2(cos(timer) * 8, sin(timer) * 16);
		vec2 scrollGrid2 = vec2(texCoord.t, texCoord.s) / 2 + vec2(sin(timer) * 7, cos(timer) * 19);
		
		vec2 waveOffset = vec2(0,0); 
		waveOffset.y = sin(scrollGrid1.x / 32 + timer * 0.25) * 32;
		waveOffset.x = sin(scrollGrid1.y / 32 + timer * 0.25) * 32;
		
		vec2 texCoordGridTop = vec2(mod(scrollGrid1.x + waveOffset.x, 256.),
			mod(scrollGrid1.y + waveOffset.y, 256.));
		vec2 texCoordGridBottom = vec2(mod(scrollGrid2.x, 256.),
			mod(scrollGrid2.y, 256.));
			
		vec2 texCoordClouds = vec2(mod(scrollClouds.x, 256.),
			mod(scrollClouds.y-256, 256.)+256);
		
		ivec2 texPosGridTop = ivec2(int(texCoordGridTop.x), int(texCoordGridTop.y));
		ivec2 texPosGridBottom = ivec2(int(texCoordGridBottom.x), int(texCoordGridBottom.y));
		ivec2 texPosClouds = ivec2(int(texCoordClouds.x), int(texCoordClouds.y));
		
		vec4 texGridTop = texture2DLod(tex, texPosGridTop.xy / vec2(256.,544.), 0.);
		vec4 texGridBottom = texture2DLod(tex, texPosGridBottom.xy / vec2(256.,544.), 0.);
		vec4 texClouds = texture2DLod(tex, texPosClouds.xy / vec2(256.,544.), 0.);
		/*vec4 texGridTop = texelFetch(tex, texPosGridTop.xy, 3);
		vec4 texGridBottom = texelFetch(tex, texPosGridBottom.xy, 3);
		vec4 texClouds = texelFetch(tex, texPosClouds.xy, 3);*/
		
		vec4 waterMix = mix(vec4(1,1,1,0), vec4(0,0,0,0), 1.0-texGridBottom.r);
		waterMix = mix(waterMix, vec4(0,0,0,0), 1.0-texGridTop.r);
		waterMix = mix(waterMix, vec4(0,0,0,0), 1.0-texClouds);
		
		vec4 waterFade = mix(closeColor, farColor, waterFog);
		
		vec4 finalMix = mix(waterMix, vec4(0.0,0.0,0.0,1.0), waterFade);
		
		finalMix = clamp(finalMix, 0.0, 1.0);
		
		ivec2 texPosRamp = ivec2(int(finalMix.r*255), int(513));
		return texture2DLod(tex, texPosRamp.xy / vec2(256.,544.), 0.);//texelFetch(tex, texPosRamp.xy, 0);
	#else
		return vec4(1.0,1.0,0.0,1.0);
	#endif
}