uniform float timer;

const float pi = 3.14159265358979323846;

vec4 Process(vec4 color)
{
	vec2 uv = gl_TexCoord[0].st;
	vec3 eyePos = normalize(pixelpos.xyz - camerapos.xyz);
	
	eyePos *= -1;
	
	float horzUV = atan(eyePos.z,eyePos.x) / 3.14/2;
	float vertUV = (eyePos.y/2) - 0.5;
	
	vec2 newPos = vec2(-horzUV, vertUV) * 8.0;
	newPos.x += sin(pi * (newPos.y * 0.5 + timer * 0.1)) * 0.25;
	newPos.y += sin(pi * (newPos.x * 0.5 + timer * 0.2)) * 0.25;
	
	vec4 portal1 = getTexel(newPos);
	
	newPos = uv;//vec2(-horzUV, vertUV) * 6.0;
	newPos.x += sin(pi * (newPos.y * 0.5 + timer * 0.3)) * 0.25;
	newPos.y += sin(pi * (newPos.x * 0.5 + timer * 0.4)) * 0.25;
	
	vec4 portal2 = getTexel(newPos);
	
	return mix(portal1, portal2, portal2.r);
}