class RampUIHandler : EventHandler {
       
    override void RenderOverlay(RenderEvent e)
    {
        if (level.time > (35 * 7)) {
            return;
        }
        //If a map name entry exists for this map, start the display
        String mapName = level.MapName;
        String mapNameKey  = "$" .. mapName .. "NAME";
        String mapAuthKey  = "$" .. mapName .. "AUTH";
        String mapMusicKey = "$" .. mapName .. "MUSC";

        String mapTitle = StringTable.Localize(mapNameKey);

        if ("$" .. mapTitle == mapNameKey) {
            return;
        }
        String mapAuthor = StringTable.Localize(mapAuthKey);
        String mapMusic = StringTable.Localize(mapMusicKey);
        
        String statusBarTexture = "RAMPSTA2";
        
        RenderWelcomeBar(mapTitle, mapAuthor, mapMusic, statusBarTexture, level.time);
        if (RampDataLibrary.instOrNull() != null &&
            RampDataLibrary.Maps(level.LevelNum) != null &&
            RampDataLibrary.Maps(level.LevelNum).canJump) {
            RenderJumpBar(level.time);
        }

    }
    
    ui void RenderWelcomeBar(String mapTitle, String mapAuthor, String mapMusic, String statusBarTexture, int timing)
    {
        double alpha = 1.0;
        if (timing < 20) {
            alpha = timing / 20.0;
        }
        if (timing > 35 * 4) {
            alpha = ((35*5)-timing) / 35.0;
        }
        
        let font = Font.GetFont("BIGFONT");
        let smallFont = Font.GetFont("SMALLFONT");
        ScreenDrawTexture(TexMan.CheckForTexture(statusBarTexture, 0), -0.2, 0.0, scale: 1, alpha: alpha);
        screenDrawString(mapTitle, Font.CR_WHITE, font,          0.5, 0.020, centerX: true, alpha: alpha);
        screenDrawString(mapAuthor, Font.CR_WHITE, smallFont,    0.5, 0.060, centerX: true, alpha: alpha);
        screenDrawString(mapMusic, Font.CR_WHITE, smallFont,     0.5, 0.085, centerX: true, alpha: alpha);
    }
    
    ui void RenderJumpBar(int timing)
    {
        double alpha = 1.0;
        if (timing < 10) {
            return;
        }
        alpha = (1+sin(timing * 15)) * 0.5;
        if (timing > 35 * 3) {
            alpha = ((35*4)-timing) / 35.0;
        }
        ScreenDrawTexture(TexMan.CheckForTexture("RAMPSTAJ", 0), 1.02, 0.01, scale: 1.0, alpha: alpha, centerX: true);
    }
    
    const UI_WIDTH = 640;
	const UI_HEIGHT = 400;

	ui void ScreenDrawTexture(TextureID tex, double pct_x, double pct_y, double scale = 1.0, double alpha = 1.0, bool centerX = false, bool centerY = false, bool lowerUnpegged = false)
	{
		int x = int(pct_x * UI_WIDTH);
		int y = int(pct_y * UI_HEIGHT);
		// calculate size based on texture's scale
		int tw, th;
		[tw, th] = TexMan.GetSize(tex);
		int w = int(tw * scale);
		int h = int(th * scale);
		if ( centerX ) x -= w / 2;
		if ( centerY ) y -= h / 2;
        if ( lowerUnpegged ) y -= h;

		Screen.DrawTexture(tex, true, x, y, DTA_Alpha, alpha,
						   DTA_DestWidth, w, DTA_DestHeight, h,
						   DTA_VirtualWidth, UI_WIDTH,
						   DTA_VirtualHeight, UI_HEIGHT,
						   // ignore any sprite offsets, this is UI-land
						   DTA_LeftOffset, 0,
						   DTA_TopOffset, 0);
	}
    
	ui void ScreenDrawString(String s, Color c, Font f, double pct_x, double pct_y, double lineHeight = 1.0, double wrapWidth = 1.0, bool dropShadow = true, bool centerX = false, bool rightAlign = false, double centerYHeight = -1, double alpha = 1, double displayPercent = 1.0)
	{
		// thanks gwHero https://forum.zdoom.org/viewtopic.php?f=122&t=59381&p=1039574
		int x = int(pct_x * UI_WIDTH);
		int y = int(pct_y * UI_HEIGHT);
		// center vertically within given height
		if ( centerYHeight > 0 )
			y += int((centerYHeight * UI_HEIGHT) / 2 - (lineHeight * UI_HEIGHT) / 2);
		// split strings separated by \n into multiple lines
		Array<String> lines;
		s.Split(lines, "\n");

        int totalCharacterCount = 0;
        Array<String> dLines;
        //Let's work out our total number of lines and characters first
		for ( int i = 0; i < lines.Size(); i++ )
		{
			BrokenLines blines = f.BreakLines(lines[i], int(wrapWidth * UI_WIDTH));
			for ( int n = 0; n < blines.Count(); n++ )
            {
                String plainText = bLines.StringAt(n);
                dLines.push(plainText);
                totalCharacterCount += plainText.Length();
            }
        }

        //Now write each line until we exceed our limit
        int charactersDisplayed = 0;
        uint charactersToDisplay = uint(totalCharacterCount * displayPercent);
        for (int i = 0; i < dLines.Size(); i++)
		{
            String textToDisplay = dlines[i];
            //If the characters already displayed total above our display target, we can break
            if (charactersDisplayed >= charactersToDisplay) { break; }

            // If the target would be hit by drawing this line, we have to truncate
            if (charactersDisplayed + textToDisplay.Length() > charactersToDisplay) {
                int charactersToDisplayThisLine = (charactersToDisplay - charactersDisplayed);
                textToDisplay = textToDisplay.Left(charactersToDisplaythisLine);
            }
            // center wrapped line horizontally
            int x = int(pct_x * UI_WIDTH);
            if ( centerX )
                x -= f.StringWidth(textToDisplay) / 2;
            if ( rightAlign )
                x -= f.StringWidth(textToDisplay);
            if ( dropShadow )
            {
                // line color codes will mess up shadow color, strip em
                String plainText = textToDisplay;
                plainText.Replace("\cg", "\cm");
                plainText.Replace("\ck", "\cm");
                plainText.Replace("\cd", "\cm");
                plainText.Replace("\cv", "\cm");
                plainText.Replace("\cl", "\cm");
                Screen.DrawText(f, Font.CR_BLACK, x + 1, y + 1,
                                plainText,
                                DTA_VirtualWidth, UI_WIDTH,
                                DTA_VirtualHeight, UI_HEIGHT,
                                DTA_Alpha, alpha);
            }
            // void DrawText(Font font, int normalcolor, double x, double y, String text, ...);
            Screen.DrawText(f, c, x, y, textToDisplay,
                            DTA_VirtualWidth, UI_WIDTH,
                            DTA_VirtualHeight, UI_HEIGHT,
                            DTA_Alpha, alpha);
            // between wrap-breaks and \n-breaks, don't carriage return twice
            if ( dLines.Size() > 1 ) { y += int(lineHeight * UI_HEIGHT); }
            charactersDisplayed += textToDisplay.Length();
        }
	}

}