class RampStationMenu : RampCustomMenu {
    
    int replyStationLevelsCompleted[12];
    int replyStationLevelsAvailable[12];
    int replyStationIsOpen[12];
    int replyStationIcon[12];
    
    override RampCustomMenuReplyProperties GetReplyProperties(int response) {
        let props = new("RampCustomMenuReplyProperties");
        props.colour = Font.CR_GREEN;
        if (replyStationLevelsAvailable[response] > 0) {
            props.colour = Font.CR_GOLD;
            if (replyStationLevelsCompleted[response] >= replyStationLevelsAvailable[response]) {
                props.colour = Font.CR_LIGHTBLUE;
            }
        }
        if (replyStationIsOpen[response] == -1) {
            props.colour = Font.CR_DARKGRAY;
        }
        if (replyStationIcon[response] == 999) {
            props.colour = Font.CR_GREEN;
        }
        return props;
    }

    override String AddCustomReplyData(int replyNumber, StrifeDialogueReply reply) {
        RampDataLibrary lib = RampDataLibrary.instOrNull();
        replyStationLevelsCompleted[replyNumber] = 0;
        replyStationLevelsAvailable[replyNumber] = 0;
        replyStationIsOpen[replyNumber] = 0;
        replyStationIcon[replyNumber] = 0;
        if (reply.Args[2] > 0) {
            replyStationLevelsCompleted[replyNumber] = lib.GetLevelsCompletedAtStation(reply.Args[2]).maps;
            replyStationLevelsAvailable[replyNumber] = lib.GetLevelsAvailableAtStation(reply.Args[2]).maps;
            replyStationIsOpen[replyNumber] = lib.GetSlotIfStationOpen(reply.Args[2]);
        }
        if (reply.nextNode >= 2) {
            replyStationIcon[replyNumber] = reply.nextNode-1;
        }
        if (reply.reply == "   Ending") {
            replyStationIcon[replyNumber] = 999;
        }
        return Stringtable.Localize(reply.Reply);
    }

    override void DrawReplyDecorations(int response, int x, int y) {
    
        double ix = (x - 160.0) * CleanXfac + (screen.GetWidth() * 0.5);
        double sx = (x + 30.0) * CleanXfac + (screen.GetWidth() * 0.5);
        double sy = (y - 100.0) * CleanYfac + (screen.GetHeight() * 0.5);

        let colour = Font.CR_LIGHTBLUE;
        string mapsCompleted = "";
        if (replyStationLevelsAvailable[response] > 0) {
            mapsCompleted = replyStationLevelsCompleted[response] .. "/" .. replyStationLevelsAvailable[response];
            if (replyStationLevelsCompleted[response] < replyStationLevelsAvailable[response]) {
                colour = Font.CR_GOLD;
            }
            screen.DrawText(displayFont, colour, sx / fontScale, sy / fontScale, mapsCompleted, DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight);
        }
        if (replyStationIcon[response] > 0) {
            screen.DrawTexture(TexMan.CheckForTexture("RZONE" .. (replyStationIcon[response]-1)), false, ix / fontScale, sy / fontScale, DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight);
        }    
    }
    
    override bool ShouldSkipReply(StrifeDialogueReply reply) {
        if (reply.reply != "   Ending") {
            return false;
        }
        int stationsUnlocked = RampDataLibrary.instOrNull().stationsUnlocked;
        int stationsNeeded = RampDataLibrary.readInt("GameMode") * 6;
        if (stationsUnlocked > stationsNeeded || stationsUnlocked == 40) {
            return false;
        }
        return true;
    }
}