class SponsorSpawner : Thinker {

    bool shouldSpawn;
    int spawnTimer;
    int spawnSponsorNumber;

    static void StartSponsorSpawns() {
        SponsorSpawner spawner = new("SponsorSpawner");
        spawner.shouldSpawn = true;
    }
    
    override void Tick() {
        if (!shouldSpawn) { return; }
        spawnTimer--;
        if (spawnTimer > 0) { return; }
        spawnTimer = 25;    
        
        int x = -14288;
        if (random(0, 1) == 0) { x = -13744; }
        int y = 1480;
        if (random(0, 1) == 0) { y = -72; }
        
        int numberOfSponsorsActive = 0;
        Array<int> sponsorsActive;
        for (int i = 0; i < 61; i++) {
            sponsorsActive.push(0);
        }
        ThinkerIterator it = ThinkerIterator.Create("RampSponsor", STAT_DEFAULT);
        RampSponsor sponsor;
		while (sponsor = RampSponsor(it.Next())) {
            numberOfSponsorsActive++;
            sponsorsActive[sponsor.number] = 1;
        }
        if (numberOfSponsorsActive >= 60) { return; }
        
        while (spawnSponsorNumber < sponsorsActive.Size() && sponsorsActive[spawnSponsorNumber] == 1) {
            spawnSponsorNumber++;
            if (spawnSponsorNumber >= 60) { spawnSponsorNumber = 0; }
        }
        RampSponsor newSponsor = RampSponsor(Actor.Spawn("RampSponsor", (x, y, 48)));
        newSponsor.setAppearance(spawnSponsorNumber);
        spawnSponsorNumber = spawnSponsorNumber % 60;
    }

}