Class RampLevelMarkerA : MapMarker
{
    Default
    {
        Scale 0.125;
    }
    States
    {
    Spawn:
        RMPM A -1;
    }
}

Class RampLevelMarkerB : RampLevelMarkerA
{
    States
    {
    Spawn:
        RMPM B -1;
    }
}

Class RampLevelMarkerD : RampLevelMarkerA
{
    States
    {
    Spawn:
        RMPM D -1;
    }
}

Class RampArtMarkerA : RampLevelMarkerA
{
    States
    {
    Spawn:
        ARTM A -1;
    }
}

Class RampArtMarkerB : RampLevelMarkerA
{
    States
    {
    Spawn:
        ARTM B -1;
    }
}

Class RampGuideMarker : RampLevelMarkerA
{
    States
    {
    Spawn:
        RMPM E -1;
    }
}

Class RampSkillMarker : RampLevelMarkerA
{
    States
    {
    Spawn:
        RMPM F -1;
    }
}

Class RampLevelHoverA : Actor
{
    Default
    {
        Scale 0.25;
        +NOGRAVITY;
        +FLOATBOB;
        Radius 8;
        Height 8;
    }
    States
    {
    Spawn:
        RMPM A -1;
    }
}

Class RampLevelHoverD : RampLevelHoverA
{
    States
    {
    Spawn:
        RMPM D -1;
    }
}

Class RampLevelHoverWip : RampLevelHoverA
{
    States
    {
    Spawn:
        LWIP A -1;
    }
}

Class RampNavigationMarker : MapMarker
{
    States
    {
    Spawn:
        RNAV A 20;
        TNT1 A 10;
        loop;
    }
}

Class RampLengthHover1 : RampLevelHoverA
{
    Default {
        Scale 0.5;
    }
    States
    {
    Spawn:
        RSCF A -1;
    }
}

Class RampLengthHover2 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSCF B -1;
    }
}

Class RampLengthHover3 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSCF C -1;
    }
}

Class RampLengthHover4 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSCF D -1;
    }
}

Class RampLengthHover5 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSCF E -1;
    }
}

Class RampLengthHover6 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSCF F -1;
    }
}

Class RampLengthHover0 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSCF Z -1;
    }
}

Class RampSkillHover1 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSKF A -1;
    }
}

Class RampSkillHover2 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSKF B -1;
    }
}

Class RampSkillHover3 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSKF C -1;
    }
}
 
Class RampSkillHover4 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSKF D -1;
    }
}

Class RampSkillHover5 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSKF E -1;
    }
}

Class RampSkillHover6 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSKF F -1;
    }
}

Class RampSkillHover0 : RampLengthHover1 
{
    States
    {
    Spawn:
        RSKF Z -1;
    }
}

class StartGuide : MapSpot
{
    //$Sprite RMPME0
	Default
	{
	}
}

class MapGuide : MapSpot
{
    //$Sprite RMPME0
	Default
	{
	}
}

class StationGuide : MapSpot
{
    //$Sprite RMPME0
	Default
	{
	}
}

class David : ShotgunGuy
{
	Default
	{
		Health 30;
		Radius 20;
		Height 56;
		Mass 100;
		Speed 8;
		PainChance 170;
		Monster;
		+FLOORCLIP
        -SHOOTABLE
		SeeSound "";
		AttackSound "";
		PainSound "";
		DeathSound "";
		ActiveSound "";
		Obituary "$OB_SHOTGUY";
		Tag "David";
	}
	States
	{
	Spawn:
		DAVR AB 10 A_Look;
		Loop;
	See:
		DAVR AABB 3 A_Chase;
		Loop;
	Missile:
		Goto See;
	}
}

Class TrafficCone: EvilEye
{
    Default
    {
        Height 128;
    }
    States
    {
    Spawn:
        TCON A -1;
        Loop;
    }
}

Class RampMapLabelA : MapMarker
{
    Default
    {
        Scale 0.125;
    }
    States
    {
    Spawn:
        RMPL A -1;
    }
}

Class RampMapLabelB : MapMarker
{
    Default
    {
        Scale 0.125;
    }
    States
    {
    Spawn:
        RMPL B -1;
    }
}

Class RampMapLabelC : MapMarker
{
    Default
    {
        Scale 0.125;
    }
    States
    {
    Spawn:
        RMPL C -1;
    }
}

Class RampMapLabelD : MapMarker
{
    Default
    {
        Scale 0.125;
    }
    States
    {
    Spawn:
        RMPL D -1;
    }
}

class RampGateEnter : SectorAction
{
	Default
	{
		Health SECSPAC_HitFloor;
	}
}

class RampArtefactEnter : SectorAction
{
	Default
	{
		Health 1; //1 denotes entry
	}
}

class RampGateExit : SectorAction
{
	Default
	{
		Health 2; //2 denotes exit
	}
}

class RampPortal : MapSpot
{
	Default
	{
    //$Sprite RMPMD0
    Scale 0.1;
	}
}

class RampPortalSpawnPoint : MapSpot
{
	Default
	{
	}
}

class RampMapButton : EvilEye {
    default {
        Radius 7;
        Height 8;
        Scale 0.1;
        +NOGRAVITY;
        +USESPECIAL;
        -SOLID;
    }
    states {
        Spawn:
            RTFB A -1;
    }
}

class RampMapButtonLineTracer : LineTracer
{
    int buttonNumberHit;
    
	Actor Source;
	override ETraceStatus TraceCallback()
	{
        DNLogger.Log("Hit something of type " .. Results.HitType);
        DNLogger.Log(String.Format("Position was %d %d %d", Results.hitpos.x, results.hitpos.y, results.hitpos.z));
		if (Results.HitType == TRACE_HitActor)
		{
			// Ignore source
			if (Results.HitActor.GetClass() == "RampMapButton")
			{
                DNLogger.Log("Hit RampMapButton with index " .. Results.HitActor.height);
                buttonNumberHit = Results.HitActor.tid;
				return TRACE_Stop;
			}
		}
		return TRACE_Stop;
	}
}

class ArtefactFlashLight : PointLightAttenuated
{   
    int lifetime;
    
    override void Tick() {
        if (lifetime < 40 && lifetime % 10 == 0) {
            self.ParticleRing();
        }
        self.lifetime++;
    }

    void ParticleRing() {
        FSpawnParticleParams myParticle;
        self.GetParticleParams(myParticle);
        for (int i = 0; i < 360; i += 5) {
            vector3 particlePos = self.Vec3Angle(24.0, i, -64);
            myParticle.Pos = particlePos;
            Level.SpawnParticle(myParticle);
        }
    }
    
    void GetParticleParams(out FSpawnParticleParams myParticle) {
        myParticle.Color1 = "White";
        myParticle.Style = STYLE_None;
        myParticle.Lifetime = 200;
        myParticle.Pos = Vec3Offset(self.pos.x,self.pos.y,self.pos.z); //Spawn relative to the spawner.
        myParticle.Size = 8;
        myParticle.SizeStep = 0;
        myParticle.Vel.Z = 1;
        myParticle.StartAlpha = 1;
        myParticle.FadeStep = 0.01;
    }
}

class RampColumn : Actor
{
	Default
	{
		//$Title "Ramp Column"
		//$Category "Obstacles/Columns"
		Radius 16;
		Height 120;
		ProjectilePassHeight -16;
		+SOLID
    }
    States
    {
        Spawn:
            TSCR A -1;
    }
}

class RampWaxCandle : Actor
{
	Default
	{
		//$Category UserLights
		Radius 20;
		Height 14;
		Scale 1;
	}
		
	States
	{
		Spawn:
			CND3 ABCD 2;
			Loop;
	}
}

class RampSkullCandle : RampWaxCandle
{
	Default
	{
		//$Category UserLights
		Radius 8;
		Height 8;
		Scale 1;
	}

	States
	{
		Spawn:
			CSD3 ABCD 2;
			Loop;
	}
}

class Wolf3DPotTree : TorchTree
{
    Default
    {
        Tag "Potted Tree (Wolf3D)";
       //$Category Decoration
    }
    States{
        Spawn:
            W3PG A -1;
            Stop;
    }
}
class Wolf3DPotPlant : TorchTree
{
    Default
    {
        Tag "Potted Plant (Wolf3D)";
       //$Category Decoration
    }
    States{
        Spawn:
            W3PB A -1;
            Stop;
    }
}
class Wolf3DPotAlone: TorchTree
{
    Default
    {
        Tag "Blue Pot (Wolf3D)";
       //$Category Decoration
    }
    States{
        Spawn:
            W3PS A -1;
            Stop;
    }
}
class Wolf3DWoodBarrel : TorchTree
{
    Default
    {
        Tag "Wooden Barrel (Wolf3D)";
       //$Category Decoration
    }
    States{
        Spawn:
            W3WB A -1;
            Stop;
    }
}
class Wolf3DArmorDeco : TorchTree
{
    Default
    {
        Tag "Decorative Armor (Wolf3D)";
       //$Category Decoration
    }
    States{
        Spawn:
            W3AR A -1;
            Stop;
    }
}
class Wolf3DNaziFlag : TorchTree
{
    Default
    {
        Tag "Nazi Flag (Wolf3D)";
       //$Category Decoration
    }
    States{
        Spawn:
            W3FL A -1;
            Stop;
    }
}

class Wolf3DHangingSkeleton :   Meat2
{    
    Default
    {
        Tag "Hanging Skeleton (Wolf3D)";
       //$Category Decoration
        Height 64;
    }
    States
    {
        Spawn:
            SKLC A -1;
            Stop;
    }
}
class Wolf3DCage :   Meat2
{
    Default
    {
        Tag "Hanging Cage (Wolf3D)";
       //$Category Decoration
        Height 64;
    }
    States
    {
        Spawn:
            W3CG A -1;
            Stop;
    }
}
class Wolf3DCage2 :   Meat2
{
    Default
    {
        Tag "Hanging Cage with Skeleton (Wolf3D)";
       //$Category Decoration
        Height 64;
    }
    States
    {
        Spawn:
            W3CS A -1;
            Stop;
    }
}

class Wolf3DSkeletonFloor  :   DeadMarine
{
    Default
    {
        Tag "Skeleton (Wolf3D)";
       //$Category Decoration
    }
    States
    {
        Spawn:
            SKLF A -1;
            Stop;
    }
}

class Wolf3DBonePile  :   DeadMarine
{
    Default
    {
        Tag "Bone Pile (Wolf3D)";
       //$Category Decoration
    }
    States
    {
        Spawn:
            SKLP A -1;
            Stop;
    }
}

class RampLargeGlowingMushroom : Candle
{
	Default
	{
		//$Category Vegetation

		Radius 20;
		Height 16;

		Translation "0:255=%[0,0,0]:[0,1.0,0.5]";
	}

	override void PostBeginPlay()
	{
		super.PostBeginPlay();

		switch (Random(1, 3))
		{
			case 1:
				SetStateLabel("Shroom1");
				break;
			case 2:
				SetStateLabel("Shroom2");
				break;
			case 3:
				SetStateLabel("Shroom3");
				break;
		}
	}
	
	States
	{
		Spawn:
			MSH1 A 0;
		Shroom1:
			MSH1 A -1 Bright;
			Stop;
		Shroom2:
			MSH2 A -1 Bright;
			Stop;
		Shroom3:
			MSH3 A -1 Bright;
			Stop;
	}
}

class RampSmallGlowingMushroom : Candle
{
	Default
	{
		//$Category Vegetation

		Radius 10;
		Height 8;

		Translation "0:255=%[0,0,0]:[0,1.0,0.5]";
	}

	override void PostBeginPlay()
	{
		super.PostBeginPlay();

		switch (Random(1, 5))
		{
			case 1:
				SetStateLabel("Shroom1");
				break;
			case 2:
				SetStateLabel("Shroom2");
				break;
			case 3:
				SetStateLabel("Shroom3");
				break;
			case 4:
				SetStateLabel("Shroom4");
				break;
			case 5:
				SetStateLabel("Shroom5");
				break;
		}
	}

	States
	{
		Spawn:
			MSH4 A 0;
		Shroom1:
			MSH4 A -1 Bright;
			Stop;
		Shroom2:
			MSH5 A -1 Bright;
			Stop;
		Shroom3:
			MSH6 A -1 Bright;
			Stop;
		Shroom4:
			MSH7 A -1 Bright;
			Stop;
		Shroom5:
			MSH8 A -1 Bright;
			Stop;
	}
}

class RampSmallWorklight : Actor
{

	default
	{
		//$Title Small worklight DX
		//$Category Light sources/Worklights
		//$Angled
		//$IsDecoration
		//$Sprite WLGHA1
		Radius 25;
		Height 40;
		+SOLID
	}
	
	states
	{
	Spawn:
		WLGH A -1;
	}
}

class RampTallWorklight : RampSmallWorklight
{
	default
	{
		//$Title Tall worklight DX
		//$Category Light sources/Worklights
		//$Angled
		//$IsDecoration
		//$Sprite TLGHA1
		Height 112;
	}
	
	states
	{
	Spawn:
		TLGH A -6;
	}
}

class Tree1 : Actor
{
	Default
	{
		//$Category Tree

		Radius 4;
		Height 128;
        +SOLID;
	}

	States
	{
		Spawn:
			TR31 A -1;
			Stop;
	}
}

class Tree2 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR32 A -1;
			Stop;
	}
}

class Tree3 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR33 A -1;
			Stop;
	}
}

class Tree4 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR34 A -1;
			Stop;
	}
}

class Tree5 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR35 A -1;
			Stop;
	}
}

class Tree6 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR36 A -1;
			Stop;
	}
}

class Tree7 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR37 A -1;
			Stop;
	}
}

class Tree8 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR38 A -1;
			Stop;
	}
}

class Tree9 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR39 A -1;
			Stop;
	}
}

class Tree10 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR40 A -1;
			Stop;
	}
}

class Tree11 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR41 A -1;
			Stop;
	}
}

class Tree12 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR42 A -1;
			Stop;
	}
}

class Tree13 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR43 A -1;
			Stop;
	}
}

class Tree14 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR43 A -1;
			Stop;
	}
}

class Tree15 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR44 A -1;
			Stop;
	}
}

class Tree16 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR45 A -1;
			Stop;
	}
}

class Tree17 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR46 A -1;
			Stop;
	}
}

class Tree18 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR47 A -1;
			Stop;
	}
}

class Tree19 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR48 A -1;
			Stop;
	}
}

class Tree20 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR49 A -1;
			Stop;
	}
}

class Tree21 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR50 A -1;
			Stop;
	}
}

class Tree22 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR51 A -1;
			Stop;
	}
}

class Tree23 : Tree1
{
	Default
	{
		//$Category Tree
	}

	States
	{
		Spawn:
			TR52 A -1;
			Stop;
	}
}

class RampSponsor : DoomImp
{
    int age;
    int number;
    
    Default {
        Scale 0.3;
        -SHOOTABLE;
        -COUNTKILL;
        Radius 8;
    }
    States
    {
        X:
            RSP1 A 0;
            RSP1 B 0;
            RSP1 C 0;
            RSP1 D 0;
            RSP1 E 0;
            RSP1 F 0;
            RSP1 G 0;
            RSP1 H 0;
            RSP1 I 0;
            RSP1 J 0;
            RSP1 K 0;
            RSP1 L 0;
            RSP1 M 0;
            RSP1 N 0;
            RSP1 O 0;
            RSP1 P 0;
            RSP1 Q 0;
            RSP1 R 0;
            RSP1 S 0;
            RSP1 T 0;
            RSP1 U 0;
            RSP1 V 0;
            RSP1 W 0;
            RSP1 X 0;
            RSP1 Y 0;
            RSP1 Z 0;
            RSP2 A 0;
            RSP2 B 0;
            RSP2 C 0;
            RSP2 D 0;
            RSP2 E 0;
            RSP2 F 0;
            RSP2 G 0;
            RSP2 H 0;
            RSP2 I 0;
            RSP2 J 0;
            RSP2 K 0;
            RSP2 L 0;
            RSP2 M 0;
            RSP2 N 0;
            RSP2 O 0;
            RSP2 P 0;
            RSP2 Q 0;
            RSP2 R 0;
            RSP2 S 0;
            RSP2 T 0;
            RSP2 U 0;
            RSP2 V 0;
            RSP2 W 0;
            RSP2 X 0;
            RSP2 Y 0;
            RSP2 Z 0;
            RSP3 A 0;
            RSP3 B 0;
            RSP3 C 0;
            RSP3 D 0;
            RSP3 E 0;
            RSP3 F 0;
            RSP3 G 0;
            RSP3 H 0;
        Spawn:
            #### # 4 A_Wander;
            Loop;
    }
    
    void setAppearance(int number) {
        self.number = number;
        int spriteNameNumber = (number / 26) + 1;
        int spriteFrameNumber = number % 26;
        self.sprite = GetSpriteIndex("RSP" .. spriteNameNumber);
        self.frame = spriteFrameNumber;
    }
    
    override void Tick() {
        super.Tick();
        self.age++;
        if ((self.pos.y < -72 || self.pos.y > 1480) && self.age > 500) {
            self.destroy();
        }
    }

}