class RampGuideMenu : RampCustomMenu
{
    int replyMapStatuses[12];
    int replyMapNumbers[12];

    override RampCustomMenuReplyProperties GetReplyProperties(int response) {

	    int textColours[4] = {Font.CR_GOLD, Font.CR_LIGHTBLUE, Font.CR_WHITE, Font.CR_GRAY};
        let props = new("RampCustomMenuReplyProperties");
        props.colour = textColours[replyMapStatuses[response]];
        return props;
    }

    override String AddCustomReplyData(int replyNumber, StrifeDialogueReply reply) {
    	// Start by assuming that this is a standard option. If it has a map number attached, record it
        replyMapStatuses[replyNumber] = 3;
        replyMapNumbers[replyNumber] = 0;
        if (reply.Args[2] > 0) {
            replyMapStatuses[replyNumber] = RampDataLibrary.ReadInt("MapCompleted" .. reply.Args[2]);
            replyMapNumbers[replyNumber] = reply.Args[2];
        }

        String ReplyText = Stringtable.Localize(reply.Reply);
        if (ReplyText.Length() > 25) {
        	ReplyText = ReplyText.Left(22) .. "...";
        }
        return ReplyText;
    }

    override void DrawReplyDecorations(int response, int x, int y) {
    
        double mapZoneX = (x + 35) * CleanXfac + (screen.GetWidth() * 0.5);
        double mapSizeX = (x + 45) * CleanXfac + (screen.GetWidth() * 0.5);
        double mapDifficultyX = (x + 55) * CleanXfac + (screen.GetWidth() * 0.5);
        double sy = (y - 100.0) * CleanYfac + (screen.GetHeight() * 0.5);

       	if (replyMapNumbers[response] == 0) {
	       	return;
       	}
        RampMapInfo mapInfo = RampDataLibrary.instOrNull().Maps(replyMapNumbers[response]);
        int mapSize = mapInfo.length;
        int mapDifficulty = mapInfo.difficulty;
        int mapZone = mapInfo.zone;

        if (mapSize > 0) {
            screen.DrawText(displayFont, Font.CR_LIGHTBLUE, mapSizeX / fontScale, sy / fontScale, mapSize .. "", DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight);
            screen.DrawText(displayFont, Font.CR_RED, mapDifficultyX / fontScale, sy / fontScale, mapDifficulty .. "", DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight);
            screen.DrawTexture(TexMan.CheckForTexture("RZONE" .. mapInfo.zone), false, mapZoneX / fontScale, sy / fontScale, DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight);
        }
    }
}