class RampLoadGameHandler : StaticEventHandler {

    override void WorldLoaded(WorldEvent e) {
        DNLogger.Log("MISSION", "Static WorldLoaded has been called");
        if (level.MapName == "HUBMAP" && e.isSaveGame) {
            DNLogger.Log("MISSION", "Static WorldLoaded updated due to loading a game");
            HubController.UpdateMissionDisplay();
            HubController.DrawEndingScreen();
            LedController.inst();
        }
    }

}

class RampEventHandler : EventHandler {
    
    override void WorldLoaded(WorldEvent e) {
        DNLogger.Log("MISSION", "WorldLoaded has been called");
        RampDataLibrary.inst();
        if (level.MapName == "HUBMAP") {
            PlayerPawn p = PlayerPawn(players[consoleplayer].mo);
            p.GiveInventory("MapRevealer", 1);
            DNLogger.Log("Setting up hub");
            HubController.setupHub();
            LedController.inst();
        }
    }
    
    override void WorldUnloaded(WorldEvent e) {
        if (level.MapName == "HUBMAP") {
            //If we're unloading the hub map, get the number of secrets we had on this level when we started.
            //Store that ready for our return.
            int destination = RampDataLibrary.ReadInt("currentMap");
            //console.printf("Destination map is %d", destination);
            int secretsAlready = RampDataLibrary.ReadInt("MapFoundSecrets" .. destination);
            RampDataLibrary.WriteInt("MapSecretsOnLeavingHub", secretsAlready);
        }
        else {
            //Unloading a gameplay level: Write the total and found secrets.
            RampDataLibrary.WriteInt("MapTotalSecrets" .. level.LevelNum, level.Total_Secrets);
            RampDataLibrary.WriteInt("MapFoundSecrets" .. level.LevelNum, level.Found_Secrets);
            
            RampDataLibrary.WriteInt("MapTotalMonsters" .. level.LevelNum, level.Total_Monsters);
            RampDataLibrary.WriteInt("MapKilledMonsters" .. level.LevelNum, level.Killed_Monsters);
            
            //Keep track of the total number of monsters killed during each level, even repeat ones.
            int oldMonsterCount = RampDataLibrary.ReadInt("MapTotalKilledMonsters" .. level.LevelNum);
            int newMonsterCount = oldMonsterCount + level.Killed_Monsters;
            RampDataLibrary.WriteInt("MapTotalKilledMonsters" .. level.LevelNum, newMonsterCount);
            
            //Monster percentage, to influence artwork price
            int monsterPercent = 100;
            if (level.Total_Monsters > 0) {
                monsterPercent = (level.Killed_Monsters * 100) / level.Total_Monsters;
            }
            RampDataLibrary.WriteInt("LastMonsterPercent", monsterPercent);
        }
    }
    
    //Here are some cheats if you want them!
    override void NetworkProcess(ConsoleEvent e) {
        //Skipmap: Use a parameter to act like a map has been completed.
        //With no parameter, completes all maps.
        //Takes effect on next visit to hub
        if (e.Name == "dinnaefancy") {
            if (e.args[0] > 0) {
                RampDataLibrary.WriteInt("MapCompleted" .. e.args[0], 1);
                return;
            }
            int numberOfMaps = RampDataLibrary.inst().existentMaps;
            for (int i = 1; i <= numberOfMaps; i++) {
                RampDataLibrary.WriteInt("MapCompleted" .. i, 1);
            }
            return;
        }
        
        if (e.Name == "unlockStations") {
            if (e.args[0] > 0) {
                RampDataLibrary.inst().stationsUnlocked = e.args[0];
                HubController.setupSubwayScreens();
            }
        }
        
        if (e.Name == "seemap") {
            DNLogger.log("MISSION", "Zones to map info lists size: " .. RampDataLibrary.instOrNull().zonesToMapInfoLists.Size());
            DNLogger.log("MISSION", "Station tag to Station Info map size: " .. RampDataLibrary.instOrNull().stationTagsToInfo.CountUsed());
        }
        
        if (e.Name == "preparehallway") {
            RampDataLibrary.WriteFinalStats(null);
            return;
        }
        
        if (e.Name == "writetime") {
            if (e.args[0] > 0) {
                RampDataLibrary.UpdateGameCompletionBoard(e.args[0]);
            }
            return;
        }
        
        if (e.Name == "writelevels") {
            if (e.args[0] > 0) {
                RampDataLibrary.UpdateLevelCompletionBoard(e.args[0]);
            }
            return;
        }
        
        if (e.Name == "zonereport") {
            console.printf("Zone report");
            DictionaryIterator it = DictionaryIterator.Create(RampDataLibrary.inst().dic);
            while (it.Next()) {
                if (it.Key().Left(11) == "MapsPerZone") {
                    console.printf("%s => %s", it.Key(), it.Value());
                }
            }
        }
    }
    
    ui TextureID barTex;
    ui TextureID barTexLeft;
    ui TextureID hexTex;
    ui TextureID iconTex;
    ui TextureID labelTex;
    ui TextureID barBack;
    ui bool initialized;
    ui int barMaxWidth;
    ui double fractionUac;
    ui double fractionStar;
    ui double fractionTown;
    ui double fractionWeird; 
    ui double fractionCastle;
    ui double fractionCave;

    ui void Init(RampDataLibrary lib) {
        
        int mapsCompleted = RampDataLibrary.instOrNull().mapsCompleted;
        string hexNumber = "00" .. mapsCompleted;
        hexNumber = hexNumber.Mid(hexNumber.Length()-3);

        self.hexTex = TexMan.CheckForTexture("RTL" .. hexNumber, TexMan.Type_Any);
        self.barTex = TexMan.CheckForTexture("RCOMPBAR", TexMan.TYPE_MISCPATCH);
        self.barTexLeft = TexMan.CheckForTexture("RCOMPBAS", TexMan.TYPE_MISCPATCH);
        self.barBack = TexMan.CheckForTexture("RCOMPBAK", TexMan.TYPE_MISCPATCH);
        self.iconTex = TexMan.CheckForTexture("RCOMPZNS", TexMan.TYPE_MISCPATCH);
        self.labelTex = TexMan.CheckForTexture("RCOMPTXT", TexMan.TYPE_MISCPATCH);
        int barSizeX, barSizeY;
        [barSizeX, barSizeY] = TexMan.GetSize(barTex);
        self.barMaxWidth = barSizeX;

        // fractionUac = lib.dic.At("MapsPerZoneCompletedUAC").ToInt() * 1.0 / lib.dic.At("MapsPerZoneTotalUAC").ToInt();
        // fractionStar = lib.dic.At("MapsPerZoneCompletedNewBase").ToInt() * 1.0 / lib.dic.At("MapsPerZoneTotalNewBase").ToInt();
        // fractionTown = lib.dic.At("MapsPerZoneCompletedTown").ToInt() * 1.0 / lib.dic.At("MapsPerZoneTotalTown").ToInt();
        // fractionWeird = lib.dic.At("MapsPerZoneCompletedWeird").ToInt() * 1.0 / lib.dic.At("MapsPerZoneTotalWeird").ToInt();
        // fractionCastle = (lib.dic.At("MapsPerZoneCompletedCastle").ToInt() + lib.dic.At("MapsPerZoneCompletedHell").ToInt()) * 1.0 / (lib.dic.At("MapsPerZoneTotalCastle").ToInt() + lib.dic.At("MapsPerZoneTotalHell").ToInt());
        // fractionCave = (lib.dic.At("MapsPerZoneCompletedCave").ToInt() + lib.dic.At("MapsPerZoneCompletedTemple").ToInt()) * 1.0 / (lib.dic.At("MapsPerZoneTotalCave").ToInt() + lib.dic.At("MapsPerZoneTotalTemple").ToInt());
    }

    override void RenderOverlay(RenderEvent e) {
        
        if (level.MapName != "HUBMAP") {
            return;
        }
        RampDataLibrary lib = RampDataLibrary.instOrNull();
        if (!lib) {
            return;
        }
        if (!initialized) {
            self.Init(lib);
        }
        //DrawTextureAtCentre(hexTex, 960, 60);
        //DrawTextureAtCentre(iconTex, 960, 60);
        //DrawTextureAtCentre(labelTex, 960, 35);
        // DrawBarWithPercentage(880, 17, fractionWeird, true);
        // DrawBarWithPercentage(1040, 17, fractionStar, false);
        // DrawBarWithPercentage(865, 54, fractionUac, true);
        // DrawBarWithPercentage(1055, 54, fractionTown, false);
        // DrawBarWithPercentage(880, 94, fractionCastle, true);
        // DrawBarWithPercentage(1040, 94, fractionCave, false);
    }
    
    ui void DrawTextureAtCentre(TextureID texture, int x, int y) {
        Screen.DrawTexture(texture, false, x, y, DTA_VirtualWidth, 1920, DTA_VirtualHeight, 1080, DTA_CenterOffset, true);
    }
    
    ui void DrawBarWithPercentage(int x, int y, double fraction, bool leftward) {
        //If going leftward, shift our start point to the left end (x = the rightmost X coordinate)
        double barWidth = self.barMaxWidth * fraction;
        if (leftward) {
            x -= barMaxWidth;
            fraction = 1.0 - fraction;
            barWidth = self.barMaxWidth * fraction;
            Screen.DrawTexture(barBack, false, x, y, DTA_VirtualWidth, 1920, DTA_VirtualHeight, 1080, DTA_LeftOffset, 0, DTA_TopOffset, 0);
            Screen.DrawTexture(barTexLeft, false, x, y, DTA_VirtualWidth, 1920, DTA_VirtualHeight, 1080, DTA_LeftOffset, 0, DTA_TopOffset, 0, DTA_WindowLeftF, barWidth);
        }
        else {
            Screen.DrawTexture(barBack, false, x, y, DTA_VirtualWidth, 1920, DTA_VirtualHeight, 1080, DTA_LeftOffset, 0, DTA_TopOffset, 0);
            Screen.DrawTexture(barTex, false, x, y, DTA_VirtualWidth, 1920, DTA_VirtualHeight, 1080, DTA_LeftOffset, 0, DTA_TopOffset, 0, DTA_WindowRightF, barWidth);
        }
        
    }
    
}