class RampMapInfoList {
    
    Array<RampMapInfo> mapInfos;
    int listPointer;
    
    void push(RampMapInfo p) {
        mapInfos.push(p);
    }
    
    RampMapInfo get(int index) {
        return mapInfos[index];
    }
    
    int size() {
        return mapInfos.size();
    }
    
    void shuffle() {
        if (mapInfos.size() < 2) { return; }
        for (int shuffle = 0; shuffle < 10000; shuffle++) {
            int index1 = random(0, mapInfos.Size()-1);
            int index2 = random(0, mapInfos.Size()-1);
            RampMapInfo value1 = mapInfos[index1];
            RampMapInfo value2 = mapInfos[index2];
            mapInfos[index1] = value2;
            mapInfos[index2] = value1;
        }
    }
    
    void sortByCompleteness() {
        Array<RampMapInfo> oldList;
        oldList = mapInfos;
        mapInfos.Clear();
        for (int i = 0; i < oldList.size(); i++) {
            RampMapInfo info = oldList[i];
            if (!info.isWip) {
                mapInfos.Push(info);
            }
        }
        for (int i = 0; i < oldList.size(); i++) {
            RampMapInfo info = oldList[i];
            if (info.isWip) {
                mapInfos.Push(info);
            }
        }
    }
    
    RampMapInfo getNext() {
        if (listPointer == mapInfos.size()) { return null; }
        return mapInfos[listPointer++];
    }
    
    void rewind() {
        self.listPointer = 0;
    }
}

class RampMapInfo {
    
    int zone;
    int length;
    int difficulty;
    bool canJump;
    bool isWip;
    int levelnum;
    int monsters;
    string lumpName;
    
    static RampMapInfo Create(string zoneKey, int length, int difficulty, int monsters, bool canJump, bool isWip, int levelnum, string lumpName, int monsters = 0) {
        let me = new("RampMapInfo");
        
        int envKey = -1;
        if (zoneKey == "uac")          { envKey = 1; }
        else if (zoneKey == "cave")    { envKey = 4; }
        else if (zoneKey == "ancient") { envKey = 5; }
        else if (zoneKey == "mystery") { envKey = 6; }
        else if (zoneKey == "hell")    { envKey = 3; }
        else if (zoneKey == "castle")  { envKey = 2; }
        else if (zoneKey == "city")    { envKey = 7; }
        else if (zoneKey == "space")   { envKey = 0; }
        
        me.zone = envKey;
        me.length = length;
        me.difficulty = difficulty;
        me.canJump = canJump;
        me.isWip = isWip;
        me.levelnum = levelnum;
        me.lumpName = lumpName;
        me.monsters = monsters;
        
        return me;
    }
    
    string toString() {
        return "Map " .. self.lumpName .. " (" .. self.levelnum .. "): Zone " .. self.zone .. ", stats " .. self.length .. self.difficulty .. self.canJump .. self.isWip .. ", monsters " .. self.monsters;
    }
}

class RampStationInfo {

    string name;
    string sky;
    int pointsAvailable;
    int difficultyPointsAvailable;
    int lengthPointsAvailable;
    int monstersAvailable;

    static RampStationInfo Create(string name, string sky) {
        let me = new("RampStationInfo");
        me.name = name;
        me.sky = sky;
        return me;
    }
    
    void clearPoints() {
        self.pointsAvailable = 0;
        self.difficultyPointsAvailable = 0;
        self.lengthPointsAvailable = 0;
        self.monstersAvailable = 0;
    }
    
    string toString() {
        return "Station " .. self.name .. ": " .. self.pointsAvailable .. "(" .. self.difficultyPointsAvailable .. "d, " .. self.lengthPointsAvailable .. "l), " .. self.monstersAvailable .. " monsters";
    }
}

class RampMissionInfo {
    
    int stationTag;
    int stationY;
    int missionType;
    int missionCurrentValue;
    int missionTarget;
    
    static RampMissionInfo Create(int stationTag, int stationY, int missionType, int missionTarget) {
        let me = new("RampMissionInfo");
        me.stationTag = stationTag;
        me.stationY = stationY;
        me.missionType = missionType;
        me.missionTarget = missionTarget;
        
        return me;
    }
   
    string getMissionText() {
        if (self.missionType == 1) {
            if (self.missionTarget == 1) {
                return "Complete any map";
            }
            string num = "two";
            if (self.missionTarget == 3) { num = "three"; }
            if (self.missionTarget == 4) { num = "four"; }
            if (self.missionTarget == 5) { num = "five"; }
            if (self.missionTarget == 6) { num = "six"; }
            if (self.missionTarget == 7) { num = "seven"; }
            if (self.missionTarget >= 8) { num = "eight"; }
            return "Complete \cn" .. num .. " maps";
        }
        if (self.missionType == 2) {
            return "Finish maps worth " .. getMissionTargetValue() .. " overall pts";
        }
        if (self.missionType == 3) {
            return "Finish \cg" .. getMissionTargetValue() .. " total difficulty pts";
        }
        if (self.missionType == 4) {
            return "Finish \cv" .. getMissionTargetValue() .. " total length pts";
        }
        if (self.missionType == 5) {
            return "Kill \cn" .. getMissionTargetValue() .. " monsters";
        }
        
        return "I dinnae ken fit t' dae";
    }
    
    int getMissionCurrentValue() {
        RampCompletionInfo info = RampDataLibrary.getLevelsCompletedAtStation(self.stationTag);
        if (self.missionType == 1) {
            DNLogger.log("MISSION", "Checking for maps completed out of " .. self.missionTarget);
            return info.maps;
        }
        if (self.missionType == 2) {
            return info.points;
        }
        if (self.missionType == 3) {
            return info.difficultyPoints;
        }        
        if (self.missionType == 4) {
            return info.lengthPoints;
        }
        if (self.missionType == 5) {
            return info.monsters;
        }
        return 0;
    }
    
    int getMissionTargetValue() {
        // For display, need to translate some things...
        if (self.missionType == 1) { return missionTarget; }
        
        //This is percentage-based, so return the mission target as a percentage of the maximum available
        if (self.missionType == 2) {
            int maxAvailable = RampDataLibrary.instOrNull().stationTagsToInfo.GetIfExists(self.stationTag).pointsAvailable;
            return (maxAvailable * missionTarget) / 100;
        }
        if (self.missionType == 3) {
            int maxAvailable = RampDataLibrary.instOrNull().stationTagsToInfo.GetIfExists(self.stationTag).difficultyPointsAvailable;
            return (maxAvailable * missionTarget) / 100;
        }
        if (self.missionType == 4) {
            int maxAvailable = RampDataLibrary.instOrNull().stationTagsToInfo.GetIfExists(self.stationTag).lengthPointsAvailable;
            return (maxAvailable * missionTarget) / 100;
        }
        if (self.missionType == 5) {
            int maxAvailable = RampDataLibrary.instOrNull().stationTagsToInfo.GetIfExists(self.stationTag).monstersAvailable;
            int target = (maxAvailable * missionTarget) / 100;
            if (target > 500) {
                target = 500;
            }
            return target;
        }        
        return 0;
    }
    
    bool missionIsComplete() {
        return (self.getMissionCurrentValue() >= self.getMissionTargetValue()); 
    }
}

class RampCompletionInfo {
    int maps;
    int points;
    int difficultyPoints;
    int lengthPoints;
    int monsters;
}