class RampCustomMenuReplyProperties {

    Color colour;
    
}

class RampCustomMenu : ConversationMenu
{

	override void DrawReplies()
	{
		// Dim the screen behind the PC's choices.
		screen.Dim(
            0,
            0.45,
            (24 - 160) * CleanXfac + screen.GetWidth() / 2,
            (mYpos - 2 - 100) * CleanYfac + screen.GetHeight() / 2,
			272 * CleanXfac,
            (mResponseLines.Size() * ReplyLineHeight + 4) * CleanYfac
        );

		int y = mYpos;
		int x = 64;

        ypositions.Clear();
        
		for (int response = 0; response < mResponseLines.Size(); response++)
		{
            DrawReply(x, y, response);
			y += ReplyLineHeight;
		}
		double sy = (y - 100.0) * CleanYfac + (screen.GetHeight() * 0.5);
        ypositions.Push(sy);
	}
    
    void DrawReply(int x, int y, int response) {
        x = 64;
        double sx = (x - 160.0) * CleanXfac + (screen.GetWidth() * 0.5);
        double sy = (y - 100.0) * CleanYfac + (screen.GetHeight() * 0.5);
        
        RampCustomMenuReplyProperties replyProperties = GetReplyProperties(response);
        
        //Draw actual response line
        screen.DrawText(displayFont, replyProperties.colour, sx / fontScale, sy / fontScale, mResponseLines[response], DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight);

        ypositions.Push(sy);

        //Draw the number of this choice
        String listNumber = String.Format("%d.", response+1);
        int numberX = 50 - displayFont.StringWidth(listNumber);
        int numbersx = (numberX - 160.0) * CleanXfac + (screen.GetWidth() * 0.5);
        screen.DrawText(displayFont, Font.CR_GREY, numbersx / fontScale, sy / fontScale, listNumber, DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight);
        
        DrawReplyDecorations(response, x, y);

        if (response == mSelection)
        {
            DrawReplyCursor(x, y);
        }        
    }
    
    virtual void DrawReplyDecorations(int response, int sx, int sy) {}
    
    virtual bool ShouldSkipReply(StrifeDialogueReply reply) { return false; }

    virtual RampCustomMenuReplyProperties GetReplyProperties(int response) {
        return new("RampCustomMenuReplyProperties");
    }
    
    void DrawReplyCursor(int x, int y) {
        int colr = ((MenuTime() % 8) < 4) || GetCurrentMenu() != self ? Font.CR_RED : Font.CR_GREY;

        // custom graphic cursor color
        Color cursorTexColor;
        if (colr == Font.CR_RED) cursorTexColor = color(0xFF, 0x00, 0x00);
        else if (colr == Font.CR_GREY) cursorTexColor = color(0xCC, 0xCC, 0xCC);

        x = (50 + 3 - 160) * CleanXfac + screen.GetWidth() / 2;
        int yy = (y + ReplyLineHeight / 2 - 5 - 100) * CleanYfac + screen.GetHeight() / 2;

        // use a custom graphic (intentionally long-named to reduce collision with existing mods), with the ConFont version as the fallback
        let cursorTex = TexMan.CheckForTexture("graphics/DialogReplyCursor.png", TexMan.Type_MiscPatch);
        if (cursorTex.IsValid())
        {
            screen.DrawTexture(cursorTex, true, x / fontScale, yy / fontScale, DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight);
            screen.DrawTexture(cursorTex, true, x / fontScale, yy / fontScale, DTA_KeepRatio, true, DTA_VirtualWidth, displayWidth, DTA_VirtualHeight, displayHeight, DTA_FillColor, cursorTexColor, DTA_LegacyRenderStyle, STYLE_AddShaded);
        }
        else
        {
            screen.DrawText(ConFont, colr, x, yy, "\xd", DTA_CellX, 8 * CleanXfac, DTA_CellY, 8 * CleanYfac);
        }     
    }
    
	override int FormatReplies(int activereply)
	{
		mSelection = -1;

		StrifeDialogueReply reply;
		int r = -1;
        int displayedR = -1;
		int i = 1,j;
		for (reply = mCurNode.Children; reply != NULL; reply = reply.Next)
		{
			r++;
   			if (reply.ShouldSkipReply(mPlayer) || shouldSkipReply(reply)) { continue; }
			if (activereply == r) mSelection = i - 1;
			mResponses.Push(mResponseLines.Size());
			String localizedReply = AddCustomReplyData(r, reply);
			mResponseLines.Push(localizedReply);
			++i;
		}
		if (mSelection == -1)
		{
			mSelection = r < activereply ? r + 1 : 0;
		}

		// Determine where the top of the reply list should be positioned.
		mYpos = 100;

		if (mSelection >= mResponses.Size())
		{
			mSelection = mResponses.Size() - 1;
		}
		return mYpos;
	}
    
    virtual String AddCustomReplyData(int replyNumber, StrifeDialogueReply reply) {
    	return Stringtable.Localize(reply.Reply);
    }

    override void Ticker()
	{
        //This just makes sure that the map doesn't pause like the default behaviour
	}
    
	override void FormatSpeakerMessage()
	{
		String toSay = mCurNode.Dialogue;
        toSay = Stringtable.Localize(toSay);
		mDialogueLines = displayFont.BreakLines(toSay, SpeechWidth);
	}
    
	override void DrawSpeakerText(bool dimbg)
	{
		String speakerName = Stringtable.Localize(mCurNode.SpeakerName);
		int linesize = LineHeight * fontScale;
		int cnt = mDialogueLines.Count();
		
		// Dim the screen behind the dialogue (but only if there is no backdrop).
		if (dimbg)
		{
			int x = 14 * screen.GetWidth() / 320;
			int y = 13 * screen.GetHeight() / 200;
			int w = 294 * screen.GetWidth() / 320;
			int h = linesize * cnt + 6 * CleanYfac;
			if (speakerName.Length() > 0) h += linesize * 3 / 2;
			screen.Dim(0, 0.45f, x, y, w, h);
		}

		int x = 16 * screen.GetWidth() / 320;
		int y = 16 * screen.GetHeight() / 200;

		if (speakerName.Length() > 0)
		{
			screen.DrawText(displayFont, Font.CR_WHITE, x / fontScale, y / fontScale, speakerName, DTA_KeepRatio, !mConfineTextToBackdrop, DTA_VirtualWidth, speechDisplayWidth, DTA_VirtualHeight, displayHeight);
			y += linesize * 3 / 2;
		}
		x = 24 * screen.GetWidth() / 320;
		for (int i = 0; i < cnt; ++i)
		{
			screen.DrawText(displayFont, Font.CR_UNTRANSLATED, x / fontScale, y / fontScale, mDialogueLines.StringAt(i), DTA_KeepRatio, !mConfineTextToBackdrop, DTA_VirtualWidth, speechDisplayWidth, DTA_VirtualHeight, displayHeight);
			y += linesize;
		}
	}
}

class RampMissionCompleteMenu : RampCustomMenu {
	override void FormatSpeakerMessage()
	{
		// Format the speaker's message.
		String toSay = Stringtable.Localize(mCurNode.Dialogue);
        if (
            (RampDataLibrary.instOrNull().stationsUnlocked == (RampDataLibrary.readInt("GameMode") * 6))
            || (RampDataLibrary.instOrNull().stationsUnlocked == 39)
        ) {
            toSay = "Wow! You've completed the missions for all the stations - let's move you to the ending!";
        }        
		mDialogueLines = displayFont.BreakLines(toSay, SpeechWidth);
	}
}