//  ********************************************************
//  ***  Weapon: Winchester Shotgun                      ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR WinchesterShotgunBullets : Ammo
{
	Inventory.Amount 0
	Inventory.MaxAmount 4
	Ammo.BackpackAmount 0
	Ammo.BackpackMaxAmount 4
	Inventory.Icon SHELA0
	Scale 1.00
	States
	{
		Spawn:
			SHEL A -1
			Stop
	}
}
//--------------------------------------------------------------------------------
actor WinchesterShotgunPickup : CustomInventory
{
	Scale 0.11
	Inventory.PickupSound "misc/W_pkup"
	Inventory.PickUpMessage "You got the Winchester Shotgun!"
	states
	{
		Spawn:
			SGN7 Z -1
			Loop
		Pickup:
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgun", 1, 3)
			TNT1 A 0 A_GiveInventory("WinchesterShotgun", 1)
			TNT1 A 0 A_GiveInventory("WinchesterShotgunBullets", 4)
			stop
			TNT1 A 0 A_GiveInventory("Shell", 4)
			TNT1 A 0 A_SpawnItemEx("WinchesterShotgunPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
actor WinchesterShotgunPickupEmpty : WinchesterShotgunPickup
{
	states
	{
		Pickup:
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgun", 1, 1)
			TNT1 A 0 A_GiveInventory("WinchesterShotgun", 1)
			stop
			TNT1 A 0 A_SpawnItemEx("WinchesterShotgunPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
//--------------------------------------------------------------------------------
ACTOR WinchesterShotgun : Weapon 25055
{
	Tag "Winchester Shotgun"
	weapon.selectionorder 5200
	Weapon.AmmoType1 "Shell"
//	Weapon.AmmoGive 8
	Weapon.AmmoUse1 0
	States
	{
		Spawn:
			NULL A 0
			NULL A 1 A_SpawnItem("WinchesterShotgunPickup")
			Stop
		Ready:
			TNT1 A 0 A_JumpIfInventory("Reload",1,"Reload_Start")
			TNT1 A 0 A_JumpIfInventory("Unload",1,"Unload_Start")
			TNT1 A 0 A_JumpIfInventory("DropAmmo",1,"DropAmmo_Start")
			TNT1 A 0 A_JumpIfInventory("DropWeapon",1,"DropWeapon_Start")
			RED0 A 1 A_WeaponReady
			Loop
		Deselect:
			RED0 A 1 A_Lower
			Loop
		Select:
			RED0 A 1 A_Raise
			Loop
		Fire:
			NULL A 0
			NULL A 0 A_JumpIfInventory("WinchesterShotgunBullets", 1, 2) // Wenn genug (Ammo Magazin), dann zur Aktion gehen
			RED0 A 6 A_PlaySound("weapons/magnum/noammo") // No (Ammo Magazin) Sound (no Ammo)
			goto Ready
			NULL A 0 // Aktion
			NULL A 0 A_TakeInventory("WinchesterShotgunBullets", 1) // Eins von (Ammo Magazin) nehmen
//  	... fire code ... 
			ATT2 A 0 A_PlaySound("weapons/shotgunwinchester/fire1")
//			ATT2 A 0 A_Light2
			TNT1 A 0 A_SpawnItemEx("WeaponFireFlashItem", 0, 0, 0, 0, 0, 0, 0, SXF_NOCHECKPOSITION)//FireFlashLight
			ATT2 A 1 Bright A_FireBullets(8,8,16,4,"BulletPuff",0)//A_FireBullets(5,2,9,5,"BulletPuff",1)
			ATT2 BCDEFGHIJKLMNOPQRSTUVWXYZ 1
			ATT3 ABCDEF 1
			ATT2 A 0 Bright A_Light0
			ATT2 A 0 BRIGHT A_FireCustomMissile("CasingShotgun_x",300+random(-16,16),0,3,6)
			goto Ready
		AltFire://Fire2Spezial:
			NULL A 0
			NULL A 0 A_JumpIfInventory("WinchesterShotgunBullets", 1, 2) // Wenn genug (Ammo Magazin), dann zur Aktion gehen
			RED0 A 6 A_PlaySound("weapons/magnum/noammo") // No (Ammo Magazin) Sound (no Ammo)
			goto Ready
			NULL A 0 // Aktion
			NULL A 0 A_TakeInventory("WinchesterShotgunBullets", 1) // Eins von (Ammo Magazin) nehmen
//  	... fire code ... 
			ATT2 A 0 A_PlaySound("weapons/shotgunwinchester/fire2")
//			ATT2 A 0 A_Light2
			TNT1 A 0 A_SpawnItemEx("WeaponFireFlashItem", 0, 0, 0, 0, 0, 0, 0, SXF_NOCHECKPOSITION)//FireFlashLight
			ATT2 A 1 Bright A_FireBullets(10,10,19,4,"BulletPuff",0)//A_FireBullets(5,2,9,5,"BulletPuff",1)//(9, 9, 16, 4, ... -> old values
			ATT0 ABCDEFGHIJKLMNOPQRSTUVWXYZ 1
			ATT1 ABCDEFGHIJKLM 1
			ATT2 A 0 Bright A_Light0
			ATT2 A 0 BRIGHT A_FireCustomMissile("CasingShotgun_x",300+random(-16,16),0,3,6)
			goto Ready
/* **********          Reload          ********** */
		Reload_Start:
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgunBullets", 1, "ReloadShort_Start")
			TNT1 A 0 A_TakeInventory("Reload", 1)
			TNT1 A 0 A_JumpIfInventory("Shell", 1, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgunBullets", 4, "Ready") // magazine full
			REL0 ADGJM 1//REL0 ABCDEFGHIJKLMNO 1
		Reload_Transfer:// Ammo Transfer [load weapon] (:zu diesem Zeitpunkt ist sichergestellt, dass mindestens 1 Ammo im Inventar vorhanden ist, und dass das Magazin nicht voll ist)
			REL0 QTWZ 1 A_WeaponReady//REL0 PQRSTUVWXYZ 1
			REL1 BE 1 A_WeaponReady//REL1 ABCDE 1
			TNT1 A 0 A_TakeInventory("Shell", 1)
			TNT1 A 0 A_GiveInventory("WinchesterShotgunBullets", 1)
			REL1 F 1 A_PlaySound("weapons/shtgn2rl")
			REL1 HKNQ 1 A_WeaponReady//REL1 GHIJKLMNOPQ 1
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgunBullets", 4, "Reload_End") //if magazine is full then ready
			TNT1 A 0 A_JumpIfInventory("Shell", 1, "Reload_Transfer") //loop to load the rest | Wenn noch was im Inventar da ist, weiterladen
			goto Reload_End
		Reload_End:
			TNT1 A 0
			REL1 RSTUVWXYZ 1
			REL2 ABCDEFGHIJ 1//*K 1
//			SPAS B 4 A_PlaySound("weapons/reload")
			ATT0 HIJKLMNOPQRSTUVWXYZ 1
			ATT2 A 0 A_PlaySound("weapons/shotgunwinchester/reload")
			ATT1 ABCDEFGHIJKLM 1
			goto Ready
/* **********          ReloadShort          ********** */
		ReloadShort_Start:
			TNT1 A 0 A_TakeInventory("Reload", 1)
			TNT1 A 0 A_JumpIfInventory("Shell", 1, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgunBullets", 4, "Ready") // magazine full
			REL0 ADGJM 1//REL0 ABCDEFGHIJKLMNO 1
		ReloadShort_Transfer:// Ammo Transfer [load weapon] (:zu diesem Zeitpunkt ist sichergestellt, dass mindestens 1 Ammo im Inventar vorhanden ist, und dass das Magazin nicht voll ist)
			REL0 QTWZ 1 A_WeaponReady//REL0 PQRSTUVWXYZ 1
			REL1 BE 1 A_WeaponReady//REL1 ABCDE 1
			TNT1 A 0 A_TakeInventory("Shell", 1)
			TNT1 A 0 A_GiveInventory("WinchesterShotgunBullets", 1)
			REL1 F 1 A_PlaySound("weapons/shtgn2rl")
			REL1 HKNQ 1 A_WeaponReady//REL1 GHIJKLMNOPQ 1
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgunBullets", 4, "ReloadShort_End") //if magazine is full then ready
			TNT1 A 0 A_JumpIfInventory("Shell", 1, "ReloadShort_Transfer") //loop to load the rest | Wenn noch was im Inventar da ist, weiterladen
			goto ReloadShort_End
		ReloadShort_End:
			REL0 NMKJHGEDBA 1
			goto Ready
/* **********          Unload          ********** */
		Unload_Start:
			TNT1 A 0 A_TakeInventory("Unload", 1)
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgunBullets", 1, 1) // is ammo in magazine?
			goto Ready
			REL0 ADGJM 1//REL0 ABCDEFGHIJKLMNO 1
		Unload_Transfer: // Ammo Transfer [Entladen]
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgunBullets", 1, 1) // is ammo in magazine? Wenn im Magazin noch mindestens ein Ammo drin ist, dann zum (Ammo Transfer (Entladen)) springen
			goto Unload_End // magazine is empty -> End Unload Sequence
			REL1 QNKH 1 A_WeaponReady//REL1 QPONMLKJIHG 1
			REL1 F 1 A_PlaySound("weapons/shtgn2rl")
			TNT1 A 0 A_TakeInventory("WinchesterShotgunBullets", 1)
			TNT1 A 0 A_GiveInventory("Shell", 1)
			REL1 EBA 1 A_WeaponReady//REL1 EDCBA 1
			REL0 XUR 1 A_WeaponReady//REL0 ZYXWVUTSRQP 1
			goto Unload_Transfer //loop to unload all
		Unload_End:
			TNT1 A 0
			REL1 RTVXZ 1
			REL2 ACEGI 1//*K 1
			goto Ready
/* **********          Drop Ammo          ********** */
		DropAmmo_Start:
			TNT1 A 0 A_TakeInventory("DropAmmo", 1)
			TNT1 A 0 A_JumpIfInventory("Shell", 4, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_TakeInventory("Shell", 4)
			TNT1 A 0 A_SpawnItemEx("Shell_", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			goto Ready
/* **********          Drop Weapon          ********** */
		DropWeapon_Start:
			TNT1 A 0 A_TakeInventory("DropWeapon", 1)
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgun", 1, 1) // is weapon in inventory?
			goto Ready
			//Unload magazine start
			TNT1 A 0 A_JumpIfInventory("WinchesterShotgunBullets", 1, 1) // is ammo in magazine?
			goto DropWeapon_Start+5 // magazine is empty -> Drop Weapon
			TNT1 A 0 A_TakeInventory("WinchesterShotgunBullets", 1)
			TNT1 A 0 A_GiveInventory("Shell", 1)
			goto DropWeapon_Start+2 //loop to unload all
			//Unload magazine end
			TNT1 A 0 A_SpawnItemEx("WinchesterShotgunPickupEmpty", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			TNT1 A 1 A_TakeInventory("WinchesterShotgun", 1)
			goto Deselect+1
	}
}
