//  ********************************************************
//  ***  Weapon: Railgun                                 ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
actor RailGunXPickup : CustomInventory
{
	Scale 0.16
	Inventory.PickupSound "misc/W_pkup"
	Inventory.PickUpMessage "You got the RailGun!"
	states
	{
		Spawn:
			RGUN A -1
			Loop
		Pickup:
			TNT1 A 0 A_JumpIfInventory("RailGunX", 1, 3)
			TNT1 A 0 A_GiveInventory("RailGunX", 1)
			TNT1 A 0 A_GiveInventory("Cell", 20)
			stop
			TNT1 A 0 A_GiveInventory("Cell", 20)
			TNT1 A 0 A_SpawnItemEx("RailGunXPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
actor RailGunXPickupEmpty : RailGunXPickup
{
	states
	{
		Spawn:
			RGUN B -1
			Loop
		Pickup:
			TNT1 A 0 A_JumpIfInventory("RailGunX", 1, 1)
			TNT1 A 0 A_GiveInventory("RailGunX", 1)
			stop
			TNT1 A 0 A_SpawnItemEx("RailGunXPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
ACTOR RailGunX : Weapon 25045
{
	Tag "Railgun"
	Scale 0.8
	weapon.selectionorder 2000
	Weapon.AmmoType "Cell"
//	Weapon.AmmoGive 20
	Weapon.AmmoUse 10
	States
	{
		Spawn:
			NULL A 0
			NULL A 1 A_SpawnItem("RailGunXPickup")
			Stop
		Ready:
			TNT1 A 0 A_JumpIfInventory("DropAmmo",1,"DropAmmo_Start")
			TNT1 A 0 A_JumpIfInventory("DropWeapon",1,"DropWeapon_Start")
			RAIL A 1 A_WeaponReady
			RAIL A 0 A_TakeInventory("PhotonRifleHeat",1)
			Loop
		Deselect:
			RAIL A 1 A_Lower
			RAIL A 0 A_TakeInventory("PhotonRifleHeat",100) 
			Loop
		Select:
			RAIL A 1 A_Raise
			Loop
		Fire:
			RAIL A 0 A_JumpIfInventory("PhotonRifleHeat", 76, "Overheat")
			RAIL A 0 A_PlayWeaponSound("weapons/railgc")
			RAIL A 0 A_GiveInventory("PhotonRifleHeat",25)
			RAIL B 4 A_RailAttack(250, 8, 8,"00 00 FF", "60 60 FF")
			RAIL A 20
			goto Ready
		Overheat:
			RAIL A 0 A_PlaySound("weapons/photonoverheat")
			RAIL A 10 A_FireCustomMissile("PhotonSmoke",0,0,1,-6)
			goto Ready
/* **********          Drop Ammo          ********** */
		DropAmmo_Start:
			TNT1 A 0 A_TakeInventory("DropAmmo", 1)
			TNT1 A 0 A_JumpIfInventory("Cell", 20, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_TakeInventory("Cell", 20)
			TNT1 A 0 A_SpawnItemEx("Cell_", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			goto Ready
/* **********          Drop Weapon          ********** */
		DropWeapon_Start:
			TNT1 A 0 A_TakeInventory("DropWeapon", 1)
			TNT1 A 0 A_JumpIfInventory("RailGunX", 1, 1) // is weapon in inventory?
			goto Ready
			TNT1 A 0 A_TakeInventory("PhotonRifleHeat", 100)
			TNT1 A 0 A_SpawnItemEx("RailGunXPickupEmpty", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			TNT1 A 1 A_TakeInventory("RailGunX", 1)
			goto Deselect+1
	}
}
