//  ********************************************************
//  ***  Ammo: Magnum Ammo                               ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR MagnumBullets : Ammo
{
	Inventory.Amount 0
	Inventory.MaxAmount 12
	Ammo.BackpackAmount 0
	Ammo.BackpackMaxAmount 12
	States
	{
		Spawn:
			REVI I -1
			Stop
	}
}

//  ********************************************************
//  ***  Weapon: Magnum (Desert Eagle)                   ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
actor MagnumGunPickup : CustomInventory
{
	Scale 0.2
	Inventory.PickupSound "misc/W_pkup"
	Inventory.PickUpMessage "You got a Pistol!"
	states
	{
		Spawn:
			EAG1 Z -1
			Loop
		Pickup:
			TNT1 A 0 A_JumpIfInventory("Magnum", 1, 3)
			TNT1 A 0 A_GiveInventory("Magnum", 1)
			TNT1 A 0 A_GiveInventory("MagnumBullets", 12)
			stop
			TNT1 A 0 A_GiveInventory("Clip", 12)
			TNT1 A 0 A_SpawnItemEx("MagnumGunPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
actor MagnumGunPickupEmpty : MagnumGunPickup
{
	states
	{
		Pickup:
			TNT1 A 0 A_JumpIfInventory("Magnum", 1, 1)
			TNT1 A 0 A_GiveInventory("Magnum", 1)
			stop
			TNT1 A 0 A_SpawnItemEx("MagnumGunPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
ACTOR Magnum : Weapon replaces Pistol 25030
{
	Tag "Pistol"
	Scale 0.26
	weapon.selectionorder 999
	Weapon.AmmoType "MagnumBullets" 
	Weapon.AmmoType2 "Clip" 
	AttackSound "weapons/magnum"
	States
	{
		Spawn:
			NULL A 0
			NULL A 1 A_SpawnItem("MagnumGunPickup")
			Stop
		Ready:
			TNT1 A 0 A_JumpIfInventory("Reload",1,"Reload_Start")
			TNT1 A 0 A_JumpIfInventory("Unload",1,"Unload_Start")
			TNT1 A 0 A_JumpIfInventory("DropAmmo",1,"DropAmmo_Start")
			TNT1 A 0 A_JumpIfInventory("DropWeapon",1,"DropWeapon_Start")
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 1, 1)
			goto MagnumEmpty
			FIR0 A 1 A_WeaponReady
			Loop
		MagnumEmpty:
			FIR2 Z 1 A_WeaponReady
			goto Ready
		Deselect:
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 1, 1)
			goto DeselectEmpty
			FIR0 A 1 A_Lower
			Loop
		DeselectEmpty:
			DES2 A 1 A_Lower
			Loop
		Select:
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 1, 1)
			goto SelectEmpty
			FIR0 A 1 A_Raise
			Loop
		SelectEmpty:
			SEL2 A 1 A_Raise
			Loop
		Fire:
			TNT1 A 0
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 1, 2) // Wenn genug (Ammo Magazin), dann zur Aktion gehen
			FIR2 Y 6 A_PlaySound("weapons/magnum/noammo") // No (Ammo Magazin) Sound (no Ammo)
			goto Ready
			TNT1 A 0
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 2, 1) // Letzen Schuss ermitteln um andere Animation abzuspielen
			goto LastShot//LastShotAnimation***
			TNT1 A 0 // Aktion
			TNT1 A 0 A_TakeInventory("MagnumBullets", 1) // Eins von (Ammo Magazin) nehmen
//  	... fire code ... 
			TNT1 A 0 A_FireCustomMissile("CasingBullet_x",300+random(-16,16),0,3,6)
			TNT1 A 0 A_SpawnItemEx("WeaponFireFlashItem", 0, 0, 0, 0, 0, 0, 0, SXF_NOCHECKPOSITION)//FireFlashLight
//			TNT1 A 0 A_GunFlash
			FIR0 B 1 bright A_FireBullets (1, 1, 1, 12, "BulletPuff", 1)//A_FireBullets(4, 4, 1, 8, 0, 1, 10240)
			FIR0 CDEFGHIJKLMN 1 bright
			TNT1 A 0 A_ReFire
			goto Ready
		LastShot:
			TNT1 A 0 // Aktion
			TNT1 A 0 A_TakeInventory("MagnumBullets", 1) // Eins von (Ammo Magazin) nehmen
//  	... fire code ... 
			TNT1 A 0 A_FireCustomMissile("CasingBullet_x",300+random(-16,16),0,3,6)
			TNT1 A 0 A_SpawnItemEx("WeaponFireFlashItem", 0, 0, 0, 0, 0, 0, 0, SXF_NOCHECKPOSITION)//FireFlashLight
//			TNT1 A 0 A_GunFlash
			FIR2 B 1 bright A_FireBullets (1, 1, 1, 12, "BulletPuff", 1)//A_FireBullets(4, 4, 1, 8, 0, 1, 10240)
			FIR2 CDEFGHIJKLMN 1 bright
			TNT1 A 0 A_ReFire
			goto Ready
		AltFire:
			TNT1 A 0
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 1, 2) // Wenn genug (Ammo Magazin), dann zur Aktion gehen
			FIR2 X 6 A_PlaySound("weapons/magnum/noammo") // No (Ammo Magazin) Sound (no Ammo)
			goto Ready
			TNT1 A 0
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 2, 1) // Letzen Schuss ermitteln um andere Animation abzuspielen
			goto LastShotAlt//LastShotAnimation***
			TNT1 A 0 // Aktion
			TNT1 A 0 A_TakeInventory("MagnumBullets", 1) // Eins von (Ammo Magazin) nehmen
//  	... fire code ... 
			TNT1 A 0 A_FireCustomMissile("CasingBullet_x",300+random(-16,16),0,3,6)
			TNT1 A 0 A_SpawnItemEx("WeaponFireFlashItem", 0, 0, 0, 0, 0, 0, 0, SXF_NOCHECKPOSITION)//FireFlashLight
//			TNT1 A 0 A_GunFlash
			FIR5 B 1 bright A_FireBullets (3, 3, 1, 12, "BulletPuff", 1)
			FIR5 CDEFGHI 1 bright
			TNT1 A 0 A_ReFire
			goto Ready
		LastShotAlt:
			TNT1 A 0 // Aktion
			TNT1 A 0 A_TakeInventory("MagnumBullets", 1) // Eins von (Ammo Magazin) nehmen
//  	... fire code ... 
			TNT1 A 0 A_FireCustomMissile("CasingBullet_x",300+random(-16,16),0,3,6)
			TNT1 A 0 A_SpawnItemEx("WeaponFireFlashItem", 0, 0, 0, 0, 0, 0, 0, SXF_NOCHECKPOSITION)//FireFlashLight
//			TNT1 A 0 A_GunFlash
			FIR6 B 1 bright A_FireBullets (1, 1, 1, 12, "BulletPuff", 1)//A_FireBullets(4, 4, 1, 8, 0, 1, 10240)
			FIR6 CDEFGHIJKLMN 1 bright
			TNT1 A 0 A_ReFire
			goto Ready
/* **********          Reload          ********** */
		Reload_Start:
			TNT1 A 0
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 1, 1) // Letzen Schuss ermitteln um andere Animation abzuspielen
			goto Empty_Reload_Start//EmptyReloadAnimation***
			TNT1 A 0 A_TakeInventory("Reload", 1)
			TNT1 A 0 A_JumpIfInventory("Clip", 1, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 12, "Ready") // magazine full
			REL0 A 1
			REL0 B 1 A_PlaySound("weapons/AK47/reload1")
			REL0 DFHJLNPRTVXZ 1
			REL1 BDFHJLNPRT 1
			REL1 U 1 A_PlaySound("weapons/AK47/reload2")
			REL1 VXZ 1
			REL2 BD 1
			REL2 F 1 //A_PlaySound("weapons/AK47/reload3")
			REL2 H 1
		Reload_Transfer:// Ammo Transfer [load weapon] (:zu diesem Zeitpunkt ist sichergestellt, dass mindestens 1 Ammo im Inventar vorhanden ist, und dass das Magazin nicht voll ist)
			TNT1 A 0 A_TakeInventory("Clip", 1)
			TNT1 A 0 A_GiveInventory("MagnumBullets", 1)
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 12, "Ready") //if magazine is full then ready
			TNT1 A 0 A_JumpIfInventory("Clip", 1, "Reload_Transfer") //loop to load the rest | Wenn noch was im Inventar da ist, weiterladen
//			goto Reload_End // Da keine Munition im Inventar mehr da ist, (Jump to Anim2 [ready])
		Reload_End: // end animation of reloading
			TNT1 A 0 // (JumpPoint ready Laden [Anim2])
			goto Ready
		Empty_Reload_Start:
			TNT1 A 0 A_TakeInventory("Reload", 1)
			TNT1 A 0 A_JumpIfInventory("Clip", 1, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 12, "Ready") // magazine full
			REL5 A 1
			REL5 B 1 A_PlaySound("weapons/AK47/reload1")
			REL5 DFHJLNPRTVXZ 1
			REL6 BDFHJLNPRT 1
			REL6 U 1 A_PlaySound("weapons/AK47/reload2")
			REL6 VXZ 1
			REL7 BDFH 1
			REL7 I 2
			REL7 J 2 A_PlaySound("weapons/AK47/reload2")//A_PlaySound("weapons/AK47/reload3")
			REL7 LNPRTV 1
		goto Reload_Transfer
/* **********          Unload          ********** */
		Unload_Start:
			TNT1 A 0 A_TakeInventory("Unload", 1)
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 2, 1) // is ammo in magazine?
			goto Ready
			UNL0 ACEGI 1//STU
			TNT1 A 0 A_PlaySound("weapons/AK47/reload1")
			UNL0 JLNPR 1
			TNT1 A 0
			UNL1 CEGIKMOQSU 1//AB
//			EAG2 E 3 //A_PlaySound("weapons/AK47/reload2")
		Unload_Transfer: // Ammo Transfer [Entladen]
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 2, 1) // is ammo in magazine? Wenn im Magazin noch mindestens ein Ammo drin ist, dann zum (Ammo Transfer (Entladen)) springen
			goto Unload_End // magazine is empty -> End Unload Sequence
			TNT1 A 0 A_TakeInventory("MagnumBullets", 1)
			TNT1 A 0 A_GiveInventory("Clip", 1)
			goto Unload_Transfer //loop to unload all
		Unload_End:
			TNT1 A 0
			goto Ready
/* **********          Reload          ********** */
		DropAmmo_Start:
			TNT1 A 0 A_TakeInventory("DropAmmo", 1)
			TNT1 A 0 A_JumpIfInventory("Clip", 12, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_TakeInventory("Clip", 12)
			TNT1 A 0 A_SpawnItemEx("Clip_", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			goto Ready
		DropWeapon_Start:
			TNT1 A 0 A_TakeInventory("DropWeapon", 1)
			TNT1 A 0 A_JumpIfInventory("Magnum", 1, 1) // is weapon in inventory?
			goto Ready
			//Unload magazine start
			TNT1 A 0 A_JumpIfInventory("MagnumBullets", 1, 1) // is ammo in magazine?
			goto DropWeapon_Start+5 // magazine is empty -> Drop Weapon
			TNT1 A 0 A_TakeInventory("MagnumBullets", 1)
			TNT1 A 0 A_GiveInventory("Clip", 1)
			goto DropWeapon_Start+2 //loop to unload all
			//Unload magazine end
			TNT1 A 0 A_SpawnItemEx("MagnumGunPickupEmpty", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			TNT1 A 1 A_TakeInventory("Magnum", 1)
			goto Deselect+1
		Flash:
			EAG1 XY 1 bright
			Stop
	}
}
