//  ********************************************************
//  ***  Ammo: MP5 Ammo                                  ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR SubMachineGunBullets : Ammo
{
	Inventory.Amount 0
	Inventory.MaxAmount 30
	Ammo.BackpackAmount 0
	Ammo.BackpackMaxAmount 30
//	Inventory.Icon REVII0
	States
	{
		Spawn:
			REVI I -1
			Stop
	}
}
//  ********************************************************
//  ***  Weapon: MP7                                     ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
actor SubMachineGunPickup : CustomInventory
{
	Scale 0.18
	Inventory.PickupSound "misc/W_pkup"
	Inventory.PickUpMessage "You got the MP7 Submachinegun!"
	states
	{
		Spawn:
			MP7_ Z -1
			Loop
		Pickup:
			TNT1 A 0 A_JumpIfInventory("SubMachineGun", 1, 3)
			TNT1 A 0 A_GiveInventory("SubMachineGun", 1)
			TNT1 A 0 A_GiveInventory("SubMachineGunBullets", 30)
			stop
			TNT1 A 0 A_GiveInventory("Clip", 30)
			TNT1 A 0 A_SpawnItemEx("SubMachineGunPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
actor SubMachineGunPickupEmpty : SubMachineGunPickup
{
	states
	{
		Spawn:
			MP7_ Y -1
			Loop
		Pickup:
			TNT1 A 0 A_JumpIfInventory("SubMachineGun", 1, 1)
			TNT1 A 0 A_GiveInventory("SubMachineGun", 1)
			stop
			TNT1 A 0 A_SpawnItemEx("SubMachineGunPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
ACTOR SubMachineGun : Weapon 25046
{
	Tag "MP7"
	Scale 0.3
	weapon.selectionorder 1600
	Weapon.AmmoType "SubMachineGunBullets" 
	Weapon.AmmoType2 "Clip" 
	AttackSound "weapons/submachinegun/shot"
	States
	{
		Spawn:
			NULL A 0
			NULL A 1 A_SpawnItem("SubMachineGunPickup")
			Stop
		Ready:
			TNT1 A 0 A_JumpIfInventory("Reload",1,"Reload_Start")
			TNT1 A 0 A_JumpIfInventory("Unload",1,"Unload_Start")
			TNT1 A 0 A_JumpIfInventory("DropAmmo",1,"DropAmmo_Start")
			TNT1 A 0 A_JumpIfInventory("DropWeapon",1,"DropWeapon_Start")
			CHGG A 1 A_WeaponReady
			Loop
		Deselect:
			CHGG A 1 A_Lower
			Loop
		Select:
			CHGG A 1 A_Raise
			Loop
		Fire:
			TNT1 A 0
			TNT1 A 0 A_JumpIfInventory("SubMachineGunBullets", 1, 2) // Wenn genug (Ammo Magazin), dann zur Aktion gehen
			MP5_ A 6 A_PlaySound("weapons/magnum/noammo") // No (Ammo Magazin) Sound (no Ammo)
			goto Ready
			TNT1 A 0 // Aktion
			TNT1 A 0 A_TakeInventory("SubMachineGunBullets", 1) // Eins von (Ammo Magazin) nehmen
//  	... fire code ... 
			MP5_ A 0 A_FireCustomMissile("CasingBullet_x",300+random(-16,16),0,3,6)
			TNT1 A 0 A_SpawnItemEx("WeaponFireFlashItem", 0, 0, 0, 0, 0, 0, 0, SXF_NOCHECKPOSITION)//FireFlashLight
			MP5_ A 1 A_FireBullets (5, 5, 1, 9, "BulletPuff", 1)
			MP5_ B 2
			MP5_ A 0 A_ReFire
			goto Ready
/* **********          Reload          ********** */
		Reload_Start:
			TNT1 A 0 A_TakeInventory("Reload", 1)
			TNT1 A 0 A_JumpIfInventory("Clip", 1, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_JumpIfInventory("SubMachineGunBullets", 30, "Ready") // magazine full
			REL0 ACEGIKMOQSU 1
			REL0 W 1 A_PlaySound("weapons/submachinegun/reload1")
			REL0 Y 1
			REL1 ACEGIKMOQSU 1
			REL1 W 1 A_PlaySound("weapons/submachinegun/reload2")//MP5R E 3 A_PlaySound("weapons/AK47/reload2")//****3D
		Reload_Transfer:// Ammo Transfer [load weapon] (:zu diesem Zeitpunkt ist sichergestellt, dass mindestens 1 Ammo im Inventar vorhanden ist, und dass das Magazin nicht voll ist)
			TNT1 A 0 A_TakeInventory("Clip", 1)
			TNT1 A 0 A_GiveInventory("SubMachineGunBullets", 1)
			TNT1 A 0 A_JumpIfInventory("SubMachineGunBullets", 30, "Reload_End") //if magazine is full then ready
			TNT1 A 0 A_JumpIfInventory("Clip", 1, "Reload_Transfer") //loop to load the rest | Wenn noch was im Inventar da ist, weiterladen
//			goto Reload_End // Da keine Munition im Inventar mehr da ist, (Jump to Anim2 [ready])
		Reload_End: // end animation of reloading
			TNT1 A 0 // (JumpPoint ready Laden [Anim2])
			REL1 XZ 1
			REL2 BDFHJL 1
			REL2 L 1 A_PlaySound("weapons/submachinegun/reload3")
			REL2 NPRTVXZ 1
			REL3 BDF 1
			goto Ready
/* **********          Unload          ********** */
		Unload_Start:
			TNT1 A 0 A_TakeInventory("Unload", 1)
			TNT1 A 0 A_JumpIfInventory("SubMachineGunBullets", 1, 1) // is ammo in magazine?
			goto Ready
			REL0 ABCDEFGHIJKLM 1
			REL0 N 1 A_PlaySound("weapons/submachinegun/reload1")
		Unload_Transfer: // Ammo Transfer [Entladen]
			TNT1 A 0 A_JumpIfInventory("SubMachineGunBullets", 1, 1) // is ammo in magazine? Wenn im Magazin noch mindestens ein Ammo drin ist, dann zum (Ammo Transfer (Entladen)) springen
			goto Unload_End // magazine is empty -> End Unload Sequence
			TNT1 A 0 A_TakeInventory("SubMachineGunBullets", 1)
			TNT1 A 0 A_GiveInventory("Clip", 1)
			goto Unload_Transfer //loop to unload all
		Unload_End:
			TNT1 A 0
//			REL0 XYZ 1
//			REL1 ABCDEFGHIJ 1
//			REL1 JIHGFEDCBA 1
//			REL0 ZYX 1
//			REL0 W 1 A_PlaySound("weapons/submachinegun/reload2")//MP5R E 3 A_PlaySound("weapons/AK47/reload2")//****3D
			REL0 MLKJIHGFEDCBA 1
			goto Ready
/* **********          Drop Ammo          ********** */
		DropAmmo_Start:
			TNT1 A 0 A_TakeInventory("DropAmmo", 1)
			TNT1 A 0 A_JumpIfInventory("Clip", 12, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_TakeInventory("Clip", 12)
			TNT1 A 0 A_SpawnItemEx("Clip_", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			goto Ready
/* **********          Drop Weapon          ********** */
		DropWeapon_Start:
			TNT1 A 0 A_TakeInventory("DropWeapon", 1)
			TNT1 A 0 A_JumpIfInventory("SubMachineGun", 1, 1) // is weapon in inventory?
			goto Ready
			//Unload magazine start
			TNT1 A 0 A_JumpIfInventory("SubMachineGunBullets", 1, 1) // is ammo in magazine?
			goto DropWeapon_Start+5 // magazine is empty -> Drop Weapon
			TNT1 A 0 A_TakeInventory("SubMachineGunBullets", 1)
			TNT1 A 0 A_GiveInventory("Clip", 1)
			goto DropWeapon_Start+2 //loop to unload all
			//Unload magazine end
			TNT1 A 0 A_SpawnItemEx("SubMachineGunPickupEmpty", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			TNT1 A 1 A_TakeInventory("SubMachineGun", 1)
			goto Deselect+1
	}
}
