//  ********************************************************
//  ***  Weapon: Flame Thrower                           ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR FlameThrowerBullets : Ammo
{
	Inventory.Amount 0
	Inventory.MaxAmount 100
	Ammo.BackpackAmount 0
	Ammo.BackpackMaxAmount 100
//	Inventory.Icon REVII0
	States
	{
		Spawn:
			REVI I -1
			Stop
	}
}
actor FlameThrowerPickup : CustomInventory
{
	Scale 0.3
	Inventory.PickupSound "misc/W_pkup"
	Inventory.PickUpMessage "You got the Flamethrower!"
	states
	{
		Spawn:
			FLMM Z -1
			Loop
		Pickup:
			TNT1 A 0 A_JumpIfInventory("TheFlameThrower", 1, 3)
			TNT1 A 0 A_GiveInventory("TheFlameThrower", 1)
			TNT1 A 0 A_GiveInventory("FlameThrowerBullets", 100)
			stop
			TNT1 A 0 A_GiveInventory("Fuel", 100)
			TNT1 A 0 A_SpawnItemEx("FlameThrowerPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
actor FlameThrowerPickupEmpty : FlameThrowerPickup
{
	states
	{
		Spawn:
			FLMM X -1
			Loop
		Pickup:
			TNT1 A 0 A_JumpIfInventory("TheFlameThrower", 1, 1)
			TNT1 A 0 A_GiveInventory("TheFlameThrower", 1)
			stop
			TNT1 A 0 A_SpawnItemEx("FlameThrowerPickupEmpty", 0, 0, 0, 1, 0, 1, 0, 0, 0)
			stop
	}
}
ACTOR TheFlameThrower : Weapon 25081
{
	Tag "FlameThrower"
	Scale 0.7
	weapon.selectionorder 2400
	Obituary "%o was burninated by %k's flamethrower!"
	Weapon.AmmoType "FlameThrowerBullets"
	Weapon.AmmoType2 "Fuel" 
//	Weapon.AmmoGive 100
	States
	{
		Spawn:
			NULL A 0
			NULL A 1 A_SpawnItem("FlameThrowerPickup")
			Stop
		Ready: 
			TNT1 A 0 A_JumpIfInventory("DropAmmo",1,"DropAmmo_Start")
			TNT1 A 0 A_JumpIfInventory("DropWeapon",1,"DropWeapon_Start")
			TNT1 A 0 A_JumpIfInventory("Reload",1,"Reload_Start")
			TNT1 A 0 A_JumpIfInventory("Unload",1,"Unload_Start")
			FLMM Z 1 A_WeaponReady
			Loop
		Deselect: 
			FLMM A 1 A_Lower
			Loop
		Select: 
			FLMM A 1 A_Raise
			Loop
		Fire: 
			FLMM B 0 A_JumpIfInventory("FlameThrowerBullets", 1, 1)
			goto Ready
			FLMM B 0 A_TakeInventory("FlameThrowerBullets", 1)
			FLMM B 0 A_Playsound ("weapons/flamesht")
			FLMM BB 1 A_FireCustomMissile("Flame", Random(-3, 3), 1, 8, Random(-2, 2))
			FLMM B 0 A_TakeInventory("FlameThrowerBullets", 1)
			FLMM B 0 //A_Playsound ("weapons/flamesht")
			FLMM BB 1 A_FireCustomMissile("FlameNoDamage", Random(-4, 4), 1, 8, Random(-3, 3))
			Goto Ready
/* **********          Reload          ********** */
		Reload_Start:
			TNT1 A 0 A_TakeInventory("Reload", 1)
			TNT1 A 0 A_JumpIfInventory("Fuel", 1, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_JumpIfInventory("FlameThrowerBullets", 100, "Ready") // magazine full
			REL0 ABC 3
			REL0 D 3 A_PlaySound("weapons/AK47/reload1")
			REL0 EFGHIJ 3
			REL0 JIHGF 3
			REL0 E 3 A_PlaySound("weapons/AK47/reload2")
			REL0 DCBA 3
		Reload_Transfer:// Ammo Transfer [load weapon] (:zu diesem Zeitpunkt ist sichergestellt, dass mindestens 1 Ammo im Inventar vorhanden ist, und dass das Magazin nicht voll ist)
			TNT1 A 0 A_TakeInventory("Fuel", 1)
			TNT1 A 0 A_GiveInventory("FlameThrowerBullets", 1)
			TNT1 A 0 A_JumpIfInventory("FlameThrowerBullets", 100, "Ready") //if magazine is full then ready
			TNT1 A 0 A_JumpIfInventory("Fuel", 1, "Reload_Transfer") //loop to load the rest | Wenn noch was im Inventar da ist, weiterladen
//			goto Reload_End // Da keine Munition im Inventar mehr da ist, (Jump to Anim2 [ready])
		Reload_End: // end animation of reloading
			TNT1 A 0 // (JumpPoint ready Laden [Anim2])
			goto Ready
/* **********          Unload          ********** */
		Unload_Start:
			TNT1 A 0 A_TakeInventory("Unload", 1)
			TNT1 A 0 A_JumpIfInventory("FlameThrowerBullets", 1, 1) // is ammo in magazine?
			goto Ready
			REL0 ABC 3
			REL0 D 3 A_PlaySound("weapons/AK47/reload1")
			REL0 EFGHIJ 3
			REL0 JIHGF 3
			REL0 E 3 A_PlaySound("weapons/AK47/reload2")
			REL0 DCBA 3
		Unload_Transfer: // Ammo Transfer [Entladen]
			TNT1 A 0 A_JumpIfInventory("FlameThrowerBullets", 1, 1) // is ammo in magazine? Wenn im Magazin noch mindestens ein Ammo drin ist, dann zum (Ammo Transfer (Entladen)) springen
			goto Unload_End // magazine is empty -> End Unload Sequence
			TNT1 A 0 A_TakeInventory("FlameThrowerBullets", 1)
			TNT1 A 0 A_GiveInventory("Fuel", 1)
			goto Unload_Transfer //loop to unload all
		Unload_End:
			TNT1 A 0
			goto Ready
/* **********          Drop Ammo          ********** */
		DropAmmo_Start:
			TNT1 A 0 A_TakeInventory("DropAmmo", 1)
			TNT1 A 0 A_JumpIfInventory("Fuel", 75, 1) // is ammo in inventory?
			goto Ready
			TNT1 A 0 A_TakeInventory("Fuel", 75)
			TNT1 A 0 A_SpawnItemEx("Fuel", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			goto Ready
/* **********          Drop Weapon          ********** */
//		DropWeapon_Start:
//			TNT1 A 0 A_TakeInventory("DropWeapon", 1)
//			TNT1 A 0 A_JumpIfInventory("TheFlameThrower", 1, 1) // is weapon in inventory?
//			goto Ready
//			TNT1 A 0 A_SpawnItemEx("FlameThrowerPickupEmpty", 64, 0, 32, 5, 0, 5, 0, 0, 0)
//			TNT1 A 1 A_TakeInventory("TheFlameThrower", 1)
//			goto Deselect+1


		DropWeapon_Start:
			TNT1 A 0 A_TakeInventory("DropWeapon", 1)
			TNT1 A 0 A_JumpIfInventory("TheFlameThrower", 1, 1) // is weapon in inventory?
			goto Ready
			//Unload magazine start
			TNT1 A 0 A_JumpIfInventory("FlameThrowerBullets", 1, 1) // is ammo in magazine?
			goto DropWeapon_Start+5 // magazine is empty -> Drop Weapon
			TNT1 A 0 A_TakeInventory("FlameThrowerBullets", 1)
			TNT1 A 0 A_GiveInventory("Fuel", 1)
			goto DropWeapon_Start+2 //loop to unload all
			//Unload magazine end
			TNT1 A 0
			TNT1 A 0 A_SpawnItemEx("FlameThrowerPickupEmpty", 64, 0, 32, 5, 0, 5, 0, 0, 0)
			TNT1 A 1 A_TakeInventory("TheFlameThrower", 1)
			goto Deselect+1
	} 
} 
