//  ****************************************************************************
//  ***  Decorate: Fire Pillar                           ***
//  ********************************************************
//  ********** Fire Pillar **********
// Params: 
// Param 1: Args[0] -> 0 = NOGRAVITY, 1 = FloorClip, 2 = CeilingClip | 2 don't work
// Param 2: Args[1] -> x-monumentum -> 128 = 0 xmon | 64 -> -64*0.1 = -6.4 xmon | 192 -> 64*01 6.4 Xmon
// Param 3: Args[2] -> y-monumentum -> 128 = 0 ymon | 64 -> -64*0.1 = -6.4 ymon | 192 -> 64*01 6.4 ymon
// Param 4: Args[3] -> z-monumentum -> 128 = 0 zmon | 64 -> -64*0.1 = -6.4 zmon | 192 -> 64*01 6.4 zmon
// Param 5: Args[4] -> Fire Spread 15 is a good value
//  ********** In use by: ******************************
//  <mapobject>
Actor FirePillarMap 3554
{
	radius 0 height 0 Speed 0
	Damage 0
	+NOCLIP +NOTARGET +BLOODLESSIMPACT +NOGRAVITY
	RenderStyle None
	mass 1000000
	States
	{
	Spawn:
		TNT1 A 0
		TNT1 A 0 A_Jump(Args[0] == 1, "SetFloor")
		TNT1 A 0
		TNT1 A 0
		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot", 0, 0, 0, (random(-1*Args[4],Args[4])+Args[1]-128)*0.1, (random(-1*Args[4],Args[4])+Args[2]-128)*0.1, (random(-1*Args[4],Args[4])+Args[3]-128)*0.1, -1, SXF_NOCHECKPOSITION)
		TNT1 A 0 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, (random(-1*Args[4],Args[4])+Args[1]-128)*0.1, (random(-1*Args[4],Args[4])+Args[2]-128)*0.1, (random(-1*Args[4],Args[4])+Args[3]-128)*0.1, -1, SXF_NOCHECKPOSITION)
		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, (random(-1*Args[4],Args[4])+Args[1]-128)*0.1, (random(-1*Args[4],Args[4])+Args[2]-128)*0.1, (random(-1*Args[4],Args[4])+Args[3]-128)*0.1, -1, SXF_NOCHECKPOSITION)
//		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot", 0, 0, 0, (random(-1*Args[4],1*Args[4])+Args[1]-128)*0.1, (random(-1*Args[4],1*Args[4])+Args[2]-128)*0.1, (random(-1*Args[4],1*Args[4])+Args[3]-128)*0.1, -1, SXF_NOCHECKPOSITION)
//		TNT1 A 0 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, (random(-1*Args[4],1*Args[4])+Args[1]-128)*0.1, (random(-1*Args[4],1*Args[4])+Args[2]-128)*0.1, (random(-1*Args[4],1*Args[4])+Args[3]-128)*0.1, -1, SXF_NOCHECKPOSITION)
//		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, (random(-1*Args[4],1*Args[4])+Args[1]-128)*0.1, (random(-1*Args[4],1*Args[4])+Args[2]-128)*0.1, (random(-1*Args[4],1*Args[4])+Args[3]-128)*0.1, -1, SXF_NOCHECKPOSITION)
//Flamerflame ######bobo
//		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot", 0, 0, 0, random(17,18), random(-1,1)*0.5, random(-1,1)*0.5, -1, SXF_NOCHECKPOSITION)
//		TNT1 A 0 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, random(17,18), random(-1,1)*0.5, random(-1,1)*0.5, -1, SXF_NOCHECKPOSITION)
//		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, random(17,18), random(-1,1)*0.5, random(-1,1)*0.5, -1, SXF_NOCHECKPOSITION)
		goto Spawn+3
	SetFloor:
		TNT1 A 0 A_Gravity
		TNT1 A 0 A_SetFloorClip
		goto Spawn+3
	}
}
//  ********** Fire Pillar l **********
//  ********** In use by: ******************************
//  <mapobject>
Actor FirePillarMap_l 3551
{
	radius 0 height 0 Speed 0
	Damage 0
	+NOCLIP +NOTARGET +BLOODLESSIMPACT
	RenderStyle None
	mass 1000000
	States
	{
	Spawn:
		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot", 0, 0, 0, random(-1,1), random(-1,1), random(0,4)+9, -1, SXF_NOCHECKPOSITION)
		TNT1 A 0 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, random(-1,1), random(-1,1), random(0,4)+9, -1, SXF_NOCHECKPOSITION)
		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, random(-1,1), random(-1,1), random(0,4)+9, -1, SXF_NOCHECKPOSITION)
		loop
	}
}
//  ********** Fire Pillar m **********
//  ********** In use by: ******************************
//  <mapobject>
Actor FirePillarMap_m : FirePillarMap_l 3552
{
	States
	{
	Spawn:
		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot", 0, 0, 0, random(-1,1), random(-1,1), random(0,2)+6, -1, SXF_NOCHECKPOSITION)
		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, random(-1,1), random(-1,1), random(0,2)+6, -1, SXF_NOCHECKPOSITION)
		loop
	}
}
//  ********** Fire Pillar s **********
//  ********** In use by: ******************************
//  <mapobject>
Actor FirePillarMap_s : FirePillarMap_l 3553
{
	States
	{
	Spawn:
		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot", 0, 0, 0, random(-1,1), random(-1,1), random(0,2)+3, -1, SXF_NOCHECKPOSITION)
		TNT1 A 1 A_SpawnItemEx("FirePillarMapShot_NoLight", 0, 0, 0, random(-1,1), random(-1,1), random(0,2)+3, -1, SXF_NOCHECKPOSITION)
		loop
	}
}
//  ****************************************************************************
//  ***  Decorate: Tec                                   ***
//  ********************************************************
//  ********************************************************
//  ***  Decorate: Monitor 1 - 4                         ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecMonitor1 : RAWDecorateMetalMediumWhite1 6333
{
	+NOGRAVITY
	Health 160
	Radius 12 Height 26 Speed 0
//	painsound "imp/pain"
//	deathsound "world/barrelx"
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
ACTOR TecMonitor2 : TecMonitor1 6334
{
}
ACTOR TecMonitor3 : TecMonitor1 6335
{
}
ACTOR TecMonitor4 : TecMonitor1 6336
{
}
//  ********************************************************
//  ***  Decorate: TV                                    ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecTV : RAWDecorateMetalMediumWhite1 6337
{
	+NOGRAVITY
	Health 160
	Radius 12 Height 70 Speed 0
//	painsound "imp/pain"
//	deathsound "world/barrelx"
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: Watercan								 ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR Watercan : RAWDecorateMetalMediumWhite1 6354
{
	+PUSHABLE
	-NOGRAVITY
	Health 120 mass 999
	Radius 10 Height 20 Speed 0
	States
	{
	Spawn:
		TNT1 A 0
		TNT1 A 0 A_JumpIfHealthLower(80, "SpawnDmg")
		NULL A 5
		Loop
	SpawnDmg:
		NULL B 5
		goto SpawnDmg
	}
}
//  ********************************************************
//  ***  Decorate: GasTanks								 ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR GasTanks : RAWDecorateRockSmallWhite1 6359
{
	-PUSHABLE
	Health 200
	Radius 20 Height 24 Speed 0
	States
	{
	Death:
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItemEx("SFX_Explosion_m_Base", 0, 0, 40, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)//A_SpawnItem("TNTExplosion_KULT")
		NULL B 80
		NULL B -1
		Stop
	}
}
//  ********************************************************
//  ***  Decorate: TecPowerGeneratorPortable             ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecPowerGeneratorPortable : RAWDecorateMetalMediumWhite1 6362
{
	-PUSHABLE +SOLID
	Health 600
	Radius 20 Height 26 Speed 0
}
//  ********************************************************
//  ***  Decorate: TecPowerGeneratorDeco1                ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecPowerGeneratorDeco1 6363// : RAWDecorateMetalMediumWhite1 6363
{
	+SOLID +NODAMAGE
	-PUSHABLE
	Radius 24 Height 68 Speed 0

	Mass 999999999999
	+NOBLOOD +SHOOTABLE +DONTGIB +NOICEDEATH
	+ISMONSTER -COUNTKILL
	States
	{
	Spawn:
		NULL A 0
		NULL A 0 A_SpawnItemEx("TecPowerGeneratorDeco1_CollisionBox", -48, 0, 0, 0, 0, 0, 0, SXF_SETMASTER | SXF_NOCHECKPOSITION, 0)
		NULL A 0 A_SpawnItemEx("TecPowerGeneratorDeco1_CollisionBox", 48, 0, 0, 0, 0, 0, 0, SXF_SETMASTER | SXF_NOCHECKPOSITION, 0)
		NULL A 0 A_SpawnItemEx("TecPowerGeneratorDeco1_CollisionBox", -64, 0, 0, 0, 0, 0, 0, SXF_SETMASTER | SXF_NOCHECKPOSITION, 0)
		NULL A 0 A_SpawnItemEx("TecPowerGeneratorDeco1_CollisionBox", 64, 0, 0, 0, 0, 0, 0, SXF_SETMASTER | SXF_NOCHECKPOSITION, 0)
		NULL A 10
		goto Spawn+5
	}
}
ACTOR TecPowerGeneratorDeco1_CollisionBox
{
	Mass 999999999999
	Radius 24 Height 68 Speed 0
	+SOLID +NODAMAGE +ISMONSTER +NOBLOOD +SHOOTABLE +DONTGIB
	-PUSHABLE -COUNTKILL
	States
	{
	Spawn:
		TNT1 A 10
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: TecOilTank                            ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecOilTank_l 6372// : RAWDecorateMetalMediumWhite1 6372
{
	Mass 999999999999
	+NOBLOOD +SHOOTABLE +DONTGIB +NOICEDEATH
	+ISMONSTER -COUNTKILL

	+SOLID
	-PUSHABLE
	Health 120
	Radius 46 Height 92 Speed 0
	States
	{
	Spawn:
		NULL A 0
		NULL A 0 A_SpawnItemEx("TecOilTank_l_CollisionBox", -74, 0, 0, 0, 0, 0, 0, SXF_SETMASTER | SXF_NOCHECKPOSITION, 0)
		NULL A 0 A_SpawnItemEx("TecOilTank_l_CollisionBox", 74, 0, 0, 0, 0, 0, 0, SXF_SETMASTER | SXF_NOCHECKPOSITION, 0)
		NULL A 10
		goto Spawn+3
	Death:
		TNT1 A 0
		TNT1 A 0 A_KillChildren
		
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_Explode(400, 600, 1)
		TNT1 A 1 A_SpawnItemEx("TNTExplosion_l_NoDmg", 0, 0, 23, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)
		TNT1 A 1 A_SpawnItemEx("TNTExplosion_l_NoDmg", -64, 0, 23, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)
		TNT1 A 1 A_SpawnItemEx("TNTExplosion_l_NoDmg", 64, 0, 23, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 0, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 30, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 30, 30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", -30, 30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 0, -30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 50, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 50, 50, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", -50, 50, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 0, -50, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		Stop
	}
}
ACTOR TecOilTank_l_CollisionBox
{
	Health 120 Mass 999999999999
	Radius 46 Height 92 Speed 0
	+SOLID +ISMONSTER +NOBLOOD +SHOOTABLE +DONTGIB +NOICEDEATH
	-PUSHABLE -COUNTKILL
	States
	{
	Spawn:
		TNT1 A 10
		Loop
	Death:
		TNT1 A 0
		TNT1 A 0 A_KillMaster
		Stop
	}
}
ACTOR TecOilTank_m : RAWDecorateMetalMediumWhite1 6373
{
	Mass 999999999999
	+NOBLOOD +SHOOTABLE +DONTGIB +NOICEDEATH
	+ISMONSTER -COUNTKILL

	+SOLID// +NODAMAGE
	-PUSHABLE
	Health 80
	Radius 32 Height 56 Speed 0
	States
	{
	Spawn:
		NULL A 0
		NULL A 0 A_SpawnItemEx("TecOilTank_m_CollisionBox", -40, 0, 0, 0, 0, 0, 0, SXF_SETMASTER | SXF_NOCHECKPOSITION, 0)
		NULL A 0 A_SpawnItemEx("TecOilTank_m_CollisionBox", 40, 0, 0, 0, 0, 0, 0, SXF_SETMASTER | SXF_NOCHECKPOSITION, 0)
		NULL A 10
		goto Spawn+3
	Death:
		TNT1 A 0
		TNT1 A 0 A_KillChildren
		
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_Explode(300, 400, 1)
		TNT1 A 1 A_SpawnItemEx("TNTExplosion_m_NoDmg", 0, 0, 32, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)
		TNT1 A 1 A_SpawnItemEx("TNTExplosion_m_NoDmg", -48, 0, 23, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)
		TNT1 A 1 A_SpawnItemEx("TNTExplosion_m_NoDmg", 48, 0, 23, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 0, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 30, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 30, 30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", -30, 30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 0, -30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 50, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 50, 50, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", -50, 50, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 0, -50, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		Stop
	}
}
ACTOR TecOilTank_m_CollisionBox
{
	Health 80 Mass 999999999999
	Radius 32 Height 56 Speed 0
	+SOLID +ISMONSTER +NOBLOOD +SHOOTABLE +DONTGIB +NOICEDEATH
	-PUSHABLE -COUNTKILL
	States
	{
	Spawn:
		NULL A 10
		Loop
	Death:
		TNT1 A 0
		TNT1 A 0 A_KillMaster
		Stop
	}
}
//  ********************************************************
//  ***  Decorate: TecCamera                             ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecCameraAnimated : RAWDecorateMetalMediumWhite1 6374
{
	+SOLID +NODAMAGE +SPAWNCEILING +DONTFALL +NOGRAVITY
	-PUSHABLE -FLOORCLIP
	Radius 8 Height 16 Speed 0
	States
	{
	Spawn:
		NULL ABCDEFGHIJKLMNOPQRST 4
		NULL TSRQPONMLKJIHGFEDCBA 4
		Loop
	}
}
ACTOR TecCamera : RAWDecorateMetalMediumWhite1 6375
{
	+SOLID +NODAMAGE +SPAWNCEILING +DONTFALL +NOGRAVITY
	-PUSHABLE -FLOORCLIP
	Radius 8 Height 16 Speed 0
}
//  ********************************************************
//  ***  Decorate: TecBench                              ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecBench : RAWDecorateMetalMediumWhite1 6376
{
	+SOLID +NODAMAGE
	-PUSHABLE
	Radius 24 Height 40 Speed 0
}
//  ********************************************************
//  ***  Decorate: Palette                               ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecPipeStack_l : RAWDecorateMetalMediumWhite1 6364
{
	+SOLID +NODAMAGE
	-PUSHABLE
	Radius 66 Height 60 Speed 0
}
ACTOR TecPipeStack_m : TecPipeStack_l 6365
{
	Radius 32 Height 32 Speed 0
}
ACTOR TecPipeStack_s : TecPipeStack_l 6366
{
	Radius 22 Height 16 Speed 0
}
ACTOR TecPalSingle : RAWDecorateWoodMediumBrown1 6367
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	+PUSHABLE +SHOOTABLE
	Health 400
	Radius 60 Height 10 Speed 0
}
ACTOR TecBarrelRed : RAWDecorateMetalMediumWhite1 6368
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	+PUSHABLE +SHOOTABLE
	Health 30
	Radius 10 Height 32 Speed 0
	States
	{
	Death:
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_Explode(300, 200, 1)
		TNT1 A 1 A_SpawnItemEx("TNTExplosion_m_NoDmg", 0, 0, 23, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)
		Stop
	}
}
ACTOR TecBarrelYellow : RAWDecorateMetalMediumWhite1 6369
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	+PUSHABLE +SHOOTABLE
	Health 60
	Radius 10 Height 32 Speed 0
	states
	{
	Death:
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 0 A_SpawnItem("metalwChunkGenerator",0,0,0,0) //Metal (white)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 0, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 30, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 30, 30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", -30, 30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		TNT1 A 2 A_SpawnItemEx("FireOnFloorShot", 0, -30, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
		stop
	}
}
//  ****************************************************************************
//  ***  Decorate: Gore                                  ***
//  ********************************************************
//  ********************************************************
//  ***  Decorate: Guy on wall                           ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR GoreGuyOnWall : RAWDecorateMeatMediumRed1 6338
{
	+NOGRAVITY
	Health 160
	Radius 16 Height 64 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: Guy sitting                           ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR GoreGuySitting : RAWDecorateMeatMediumRed1 6339
{
	+NOGRAVITY
	Health 160
	Radius 16 Height 30 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: Guy on Floor noHead                   ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR GoreGuyOnFloorNoHead : RAWDecorateMeatMediumRed1 6353
{
	+NOGRAVITY
	Health 160
	Radius 24 Height 10 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ****************************************************************************
//  ***  Decorate: Furniture                             ***
//  ********************************************************
//  ********************************************************
//  ***  Decorate: Cabinet                               ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR FurnitureCabinet : RAWDecorateWoodMediumBrown1 6340
{
	Health 260
	Radius 12 Height 26 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: Wardrobe                              ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR FurnitureWardrobe : RAWDecorateWoodMediumBrown1 6341
{
	Health 360
	Radius 32 Height 58 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: DeskChair                             ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR FurnitureDeskChair : RAWDecorateMetalMediumWhite1 6342
{
	+PUSHABLE
	Health 230 Mass 9999
	Radius 16 Height 25 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: Seat                                  ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR FurnitureSeat : RAWDecorateMetalMediumWhite1 6343
{
	+PUSHABLE
	Health 260 Mass 999999999
	Radius 18 Height 25 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: Table                                 ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR FurnitureTable : RAWDecorateWoodMediumBrown1 6344
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	+PUSHABLE
	Health 160 Mass 99999
	Radius 22 Height 34 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: MiniTable                             ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR FurnitureMiniTable : RAWDecorateWoodSmallBrown1 6345
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	+PUSHABLE
	Health 160 Mass 999
	Radius 16 Height 25 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ********************************************************
//  ***  Decorate: GlasTable                             ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR FurnitureGlasTable : RAWDecorateMetalMediumWhite1 6346
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	+PUSHABLE
	Health 160 Mass 99999
	Radius 20 Height 25 Speed 0
	States
	{
	Spawn:
		NULL A 1
		Loop
	}
}
//  ****************************************************************************
//  ***  Decorate: World                                 ***
//  ********************************************************
//  ********************************************************
//  ***  Decorate: StoneTable                            ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR StoneTable : RAWDecorateRockSmallWhite1 6355
{
	-PUSHABLE
	Health 460
	Radius 22 Height 28 Speed 0
}
//  ********************************************************
//  ***  Decorate: Torch                                 ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR WorldTorch : RAWDecorateUndestroyable 6347
{
	-SHOOTABLE -PUSHABLE// -SOLID
	Radius 6 Height 12 Speed 0
}
//  ********************************************************
//  ***  Decorate: Lantern                               ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR WorldLantern : RAWDecorateMetalMediumWhite1 6348
{
	Health 600
	Radius 6 Height 112 Speed 0
}
//  ********************************************************
//  ***  Decorate: Statue                                ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR WorldStatue4 : RAWDecorateRockSmallWhite1 6349
{
	Health 600
	Radius 8 Height 88 Speed 0
}
//  ****************************************************************************
//  ***  Decorate: Boxes                                 ***
//  ********************************************************
//  ********************************************************
//  ***  Decorate: BoxBrown1                             ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR BoxBrown1_l : RAWDecorateRockSmallWhite1 6356
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	+SOLID +NODAMAGE
	-PUSHABLE
//	Health 1600
	Radius 58 Height 94 Speed 0
}
ACTOR BoxBrown1_m : RAWDecorateRockSmallWhite1 6357
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	+NODAMAGE
	-PUSHABLE
//	Health 1000
	Radius 35 Height 56 Speed 0
}
ACTOR BoxBrown1_s : RAWDecorateRockSmallWhite1 6358
{
	+ACTLIKEBRIDGE +DONTOVERLAP +CANPASS +DONTRIP
	-PUSHABLE
	Health 400
	Radius 18 Height 29 Speed 0
}
//  ****************************************************************************
//  ***  Decorate: Sanitary                              ***
//  ********************************************************
//  ********************************************************
//  ***  Decorate: Sink                                  ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR SanitarySink : RAWDecoratePorcelainMediumWhite1 6350
{
	Health 160
	Radius 12 Height 32 Speed 0
	deathsound "break/glas2"
}
//  ********************************************************
//  ***  Decorate: SinkTaps                              ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR SanitarySinkTaps : RAWDecoratePorcelainMediumWhite1 6351
{
	-SHOOTABLE
	Radius 3 Height 3 Speed 0
}
//  ********************************************************
//  ***  Decorate: Toilet                                ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR SanitaryToilet : RAWDecoratePorcelainMediumWhite1 6352
{
	Health 200
	Radius 12 Height 24 Speed 0
	deathsound "break/glas2"
}
//  ****************************************************************************
//  ***  Decorate: Lights                                ***
//  ********************************************************
//  ********************************************************
//  ***  Decorate: Candle2                               ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR Candle2 : RAWDecorateMetalTorchMediumBrown1 6360
{
	+PUSHABLE -SOLID
	Health 80 Mass 99
	Radius 4 Height 14 Speed 0
	states
	{
	Spawn:
		NULL A 0 A_CheckSight(2)
		NULL A 2 A_SpawnItemEx("YellowFire_xs", 0, 0, 11, 0.01 * Random(-5, 5), 0.01 * Random(-5, 5), 0.1 * Random(1, 3), 0)
		Goto Spawn
		NULL A 1
		Goto Spawn
	Death:
		TNT1 A 1
		Stop
	}
}
//  ********************************************************
//  ***  Decorate: Tec Standing Light                    ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR TecLightStanding1 : RAWDecorateMetalMediumWhite1 6361
{
	-PUSHABLE +SOLID
	Health 460
	Radius 8 Height 54 Speed 0
}
//6376 last ObjectID