//  ********************************************************
//  ***  Weapon: Arch-Vile-Fire                          ***
//  ********************************************************
//  DemonicEnergyProjector
Actor FireSpark
{
	PROJECTILE
	damage 0
	Radius 8 Height 8 Speed 160//333
	Scale  1.0
	+NOGRAVITY +friendly
	States
	{
	Spawn:
		TNT1 A 1
		loop
	Death:
		TNT1 A 0 A_SpawnItemEx("FireSparkSpawner", 0, 0, 0, 0, 0, 0, 0, SXF_NOCHECKPOSITION, 0)
		stop
	}
}
Actor FireSparkSpawner
{
	Radius 0 Height 1 Speed 0
	RENDERSTYLE Add
	DamageType Fire
	ALPHA 1.00
	+NOGRAVITY +SEEKERMISSILE +NOTARGET +NODAMAGETHRUST
	States
	{
	Spawn:
		TNT1 A 0
		TNT1 A 0 //A_StartFire
		NULL A 0 Bright A_Explode(12,32, 0)
		TNT1 AA 1 A_SpawnItemEx("FireSparkFX", 0, 0, 0, 0.01 * Random(0, 25), 0.01 * Random(0, 25), 0.01 * Random(300, 600), 0, 128, 0)
		TNT1 A 0 //A_Fire
		TNT1 AA 1 A_SpawnItemEx("FireSparkFX", 0, 0, 0, 0.01 * Random(0, 25), 0.01 * Random(0, 25), 0.01 * Random(300, 600), 0, 128, 0)
		Stop
	}
}
//***   ArchVille Fire   ***
Actor FireSparkFX
{
	+NoGravity +NoBlockmap +ForceXYBillboard
	Radius 0 Height 0 Speed 4
	XScale 0.1 YScale 0.25
	RenderStyle Add
	Alpha 0.7
	States
	{
	Spawn:
		TNT1 A 0
		TNT1 A 0 ThrustThing(Random(0, 255), Random(0, 1))
		TNT1 A 0 ThrustThingZ(0, Random(0, 6), 0, 1)
		TNT1 A 0 A_Jump(255, 1, 2, 3, 4)
		EXN1 A 1 Bright A_FadeOut(0.06)
		Wait
		EXN2 A 1 Bright A_FadeOut(0.06)
		Wait
		EXN3 A 1 Bright A_FadeOut(0.06)
		Wait
		EXN4 A 1 Bright A_FadeOut(0.06)
		Wait
	}
}
//  ********************************************************
//  ***  Weapon: Meteor                                  ***
//  ********************************************************
//  DemonicEnergyProjector
ACTOR MagicHandsMeteor : Meteor_m
{
	Decal DoomImpScorch
	Gravity 0.01
	Radius 8 Height 8 Speed 20
	Damage 25
	States
	{
		Death:
			TNT1 A 0
			TNT1 A 0 Radius_Quake(3, 28, 1, 4, 0)
			TNT1 A 0 A_Explode(160, 168)//Damage, Radius
			goto EndAnimation
	}
}
//  ********************************************************
//  ***  Weapon: Running FireWall                        ***
//  ********************************************************
//  DemonicEnergyProjector
ACTOR HFirex_Wand//SFX_HFirex_Wand replaces HFirex_Wand
{
	Gravity 15
	PROJECTILE
	+DROPOFF +SLIDESONWALLS +NOEXPLODEFLOOR +FIREDAMAGE +FLOORCLIP
	Scale 1.5
	Speed 10
	Radius 7.5
	Height 5
	Damage 10//13
	RENDERSTYLE ADD
	ALPHA 0.67
	States
	{
		Spawn:
			TNT1 A 3 bright A_SpawnItemEx("FirePillarShot", 0, 0, 0, random(-1,1), random(-1,1), random(-1,1), -1, SXF_NOCHECKPOSITION)
			TNT1 A 0 A_Gravity
			TNT1 AAA 3 bright A_SpawnItemEx("FirePillarShot_NoLight", 0, 0, 0, random(-1,1), random(-1,1), random(-1,1), -1, SXF_NOCHECKPOSITION)
			TNT1 A 0 A_ChangeFlag(FLOORHUGGER,1)
			TNT1 A 3 bright A_SpawnItemEx("FirePillarShot_NoLight", 0, 0, 0, random(-1,1), random(-1,1), random(-1,1), -1, SXF_NOCHECKPOSITION)
			loop
		Death:
			TNT1 A 3 bright A_SpawnItemEx("FirePillarShot_NoLight", 0, 0, 0, random(-1,1), random(-1,1), random(-1,1), -1, SXF_NOCHECKPOSITION)
			Stop
	}
}
ACTOR HFirex_Wand_ : HFirex_Wand//SFX_HFirex_Wand_ : SFX_HFirex_Wand replaces HFirex_Wand_
{
	+MISSILE
}
//2nd
ACTOR MagichandFloorHFirex : FireOnFloor//SFX_MagichandFloorHFirex : SFX_FireOnFloor replaces MagichandFloorHFirex
{
	Gravity 1000
}
ACTOR MagichandFloorHFirex_nolight : MagichandFloorHFirex
{
	States
	{
		Spawn:
			NULL A 8 A_Gravity
			FRTF ABC 3 bright
			FRTF ABC 3 bright
			FRTF C 0 A_Explode
			FRTF C 0 A_Jump(161,8)
			FRTF C 0 A_Jump(191,4)
			FRTF ABC 3 bright
			FRTF ABC 3 bright
			FRTF ABC 3 bright
			FRTF C 0 A_Explode
			FRTF DEFGHIJ 3 bright
			FRTF ABC 3 bright
			FRTF C 0 A_Explode
			FRTF DEFGHIJ 3 bright
			FRTF ABC 3 bright
			FRTF C 0 A_Explode
			FRTF DEFGHIJ 3 bright
			FRTF ABC 3 bright
			FRTF C 0 A_Explode
			FRTF DEFGHIJ 3 bright
			FRTF KLMNO 3 bright
			Stop
	}
}
//  ********************************************************
//  ***  Weapon: RandomFire [growing]                    ***
//  ********************************************************
//  DemonicEnergyProjector
ACTOR MagichandFloorFireShot_1_Start
{
	gravity 1000
	+RANDOMIZE
	Radius 3
	Height 3
	Speed 160
	Scale 0.5
	PROJECTILE
	RENDERSTYLE ADD
	ALPHA 0.67
	States
	{
		Spawn:
			NULL A 1 A_Gravity
			loop
		Death:
			NULL A 0 A_CustomMissile("MagichandFloorFireShot_1", 2, 0, Random(-4, 4), 0)
			Stop
	}
}
ACTOR MagichandFloorFireShot_1
{
	gravity 1000
	Radius 3
	Height 3
	Speed 8
	Scale 0.5
	PROJECTILE
	RENDERSTYLE ADD
	States
	{
		Spawn:
			NULL A 5 A_Gravity
			NULL A 0 A_Jump(2, 6) // Lifetime (lower is longer)
			NULL A 0 A_Jump(127, 4)
			NULL A 0 A_CustomMissile("MagichandFloorFireShot_1", 2, 0, (Random(0, 32) + 96))
			TNT1 A 1 A_SpawnItemEx("MagichandFloorHFirex", 0, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
			Stop
			NULL A 0
			NULL A 0 A_CustomMissile("MagichandFloorFireShot_1", 2, 0, (Random(-32, 0) - 96))
			NULL A 0
			TNT1 A 1 A_SpawnItemEx("MagichandFloorHFirex", 0, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
			Stop
			NULL A 0
			Goto Death
		Death:
			NULL A 0
			NULL A 0 A_Jump(96, 6) // chance to spawn a second fire (lower is greater)
			NULL A 0 A_Jump(127, 4)
			NULL A 0 A_CustomMissile("MagichandFloorFireShot_1", 2, 0, (Random(0, 1) + 127))
			TNT1 A 1 A_SpawnItemEx("MagichandFloorHFirex", 0, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
			Stop
			NULL A 0
			NULL A 0 A_CustomMissile("MagichandFloorFireShot_1", 2, 0, (Random(-1, 0) - 127))
			NULL A 0
			TNT1 A 1 A_SpawnItemEx("MagichandFloorHFirex", 0, 0, 0, 0, 0, 0, 0, 128 | SXF_NOCHECKPOSITION, 0)
			Stop
			NULL A 0
			Stop
	}
}
//  ********************************************************
//  ***  Weapon: IceFlame                                ***
//  ********************************************************
//  DemonicEnergyProjector
ACTOR MagichandPoisionSpray //Normal
{
	Translation "80:95=192:207"
	Radius 4 Height 6 Speed 32
	Damage 3//2
	PROJECTILE
	+STRIFEDAMAGE +ICEDAMAGE
//	DONTHURTSHOOTER
	RENDERSTYLE ADD
	ALPHA 0.8
	SeeSound "CacoFlame/attack"
	States
	{
		Spawn:
			ICEX ABCDEFGHHHHHHHHHHHHHHHHHHHHHHH 1
			goto Death
		Death:
			ICEX HIJKLMOP 1
			Stop
	}
}
//  ********************************************************
//  ***  Weapon: MagicHandsGreenball                     ***
//  ********************************************************
//  ********** Ice Cloud/Field **********
//  DemonicEnergyProjector
/* 
//Ice Cloud
ACTOR MagichandIceFieldShot_Start //Alt
{
	PROJECTILE
	damage 0
	Radius 8
	Height 8
	Speed 160
	Scale  1.0
	+NOGRAVITY +friendly
	States
	{
		Spawn:
			TNT1 A 1
			loop
		Death:
			TNT1 A 1 A_SpawnItem("MagichandIceFieldShot")
			Stop
	}
}
ACTOR MagichandIceFieldShot
{
	Radius 3
	Height 3
	Speed 12
	Scale 0.5
	PROJECTILE
	+NOGRAVITY +RIPPER +BLOODLESSIMPACT +FLOORHUGGER +FLOORCLIP
	States
	{
		Spawn:
			TNT1 A 0
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 0)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 16)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 32)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 48)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 64)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 80)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 96)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 112)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 128)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 144)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 160)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 176)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 192)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 208)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 224)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 240)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 256)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 272)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 288)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 304)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 320)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 336)
			TNT1 A 0 A_CustomMissile("MagichandIceFieldShot2", 0, Random(-4, 4), 352)
			Goto Death
		Death:
			TNT1 A 0
			Stop
	}
}
ACTOR MagichandIceFieldShot2
{
	Radius 3 Height 3 Speed 12
	Scale 0.5
	PROJECTILE
	+NOGRAVITY +RIPPER +BLOODLESSIMPACT +FLOORHUGGER +FLOORCLIP
	States
	{
		Spawn:
			TNT1 A 0
			TNT1 A 1 A_Jump(64, 4)
			TNT1 A 1 A_Jump(64, 3)
			TNT1 A 1 A_Jump(64, 2)
			TNT1 A 1
			TNT1 A 0
			Goto Death
		Death:
			TNT1 A 0 A_CustomMissile("MagichandIceField", Random(0, 12) + 24, Random(-4, 4), 48)
			Stop
	}
}
ACTOR MagichandIceField
{
//	Translation "112:127=[128,255,128]:[0,255,0]"
	+NOBLOCKMAP +BLOODLESSIMPACT +NOCLIP +MISSILE +RANDOMIZE +NOGRAVITY +RIPPER +FLOATBOB +STRIFEDAMAGE +ICEDAMAGE
	Damage 1
	floatspeed 16
	Scale 0.96
	Speed 0
	RENDERSTYLE ADD
	States
	{
		Spawn:
			ICEW AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA 2 A_Explode(6, 16)//A_Explode(4, 16)
			stop
	}
}
*/ 
//  ********************************************************
//  ***  Weapon: Poison Cloud/Field                      ***
//  ********************************************************
//  DemonicEnergyProjector
ACTOR MagichandPoisonFieldShot_Start
{
	Gravity 2000
	PROJECTILE
	damage 0
	Radius 8
	Height 8
	Speed 160
	Scale  1.0
	+NOGRAVITY +friendly +FLOORCLIP
	States
	{
		Spawn:
			TNT1 A 1 
			loop
		Death:
			TNT1 A 1 A_ChangeFlag(NOGRAVITY,0) //A_ChangeFlag(FLOORHUGGER,1)
			TNT1 A 4
			TNT1 A 1 A_SpawnItemEx("MagichandPoisonFieldShot", 0, 0, 4, 1, 0, 1, 0, 0, 0) //A_SpawnItem("MagichandPoisonFieldShot")
			Stop
	}
}
ACTOR MagichandPoisonFieldShot //in use by: TorturedSoulBall
{
	Radius 3
	Height 3
	Speed 12
	Scale 0.5
	PROJECTILE
	+NOGRAVITY +RIPPER +BLOODLESSIMPACT +FLOORCLIP // +FLOORHUGGER
	States
	{
		Spawn:
			TNT1 AAA 0 A_ChangeFlag(FLOORHUGGER,1)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 0)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 16)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 32)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 48)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 64)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 80)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 96)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 112)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 128)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 144)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 160)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 176)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 192)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 208)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 224)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 240)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 256)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 272)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 288)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 304)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 320)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 336)
			TNT1 A 0 A_CustomMissile("MagichandPoisonFieldShot2", 0, Random(-4, 4), 352)
			Goto Death
		Death:
			TNT1 A 0
			Stop
	}
}
ACTOR MagichandPoisonFieldShot2
{
	Radius 3 Height 3 Speed 12
	Scale 0.5
	PROJECTILE
	+NOGRAVITY +RIPPER +BLOODLESSIMPACT +FLOORCLIP // +FLOORHUGGER
	States
	{
		Spawn:
			TNT1 AAA 0 A_ChangeFlag(FLOORHUGGER,1)
			TNT1 A 1 A_Jump(64, 4)
			TNT1 A 1 A_Jump(64, 3)
			TNT1 A 1 A_Jump(64, 2)
			TNT1 A 1
			TNT1 A 0
			Goto Death
		Death:
			TNT1 A 0 A_CustomMissile("MagichandPoisonField", Random(0, 12) + 24, Random(-4, 4), 48)
			Stop
	}
}
ACTOR MagichandPoisonField //sprite PSNE in multiple use
{
	+PAINLESS
	+NOBLOCKMAP +BLOODLESSIMPACT +NOCLIP +MISSILE +RANDOMIZE +NOGRAVITY +RIPPER +FLOATBOB +STRIFEDAMAGE
	Damage 1
	floatspeed 16
	Scale 0.96
	Speed 0
	RENDERSTYLE ADD
	States
	{
		Spawn:
			PSNE AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA 2 A_Explode(4, 16)
			stop
	}
}
//  ********************************************************
//  ***  Weapon: Lighting                                ***
//  ********************************************************
//  DemonicEnergyProjector
//TNT1 A 0 A_customMissile("MagicLightning",38,-15,0,1)    
//TNT1 A 0 A_customMissile("MagicLightning",38,-15,0,CMF_TRACKOWNER, 1)
ACTOR MagichandLightingShot_small //normal fire
{
	PROJECTILE
	Damage 3
	Radius 8 Height 8 Speed 160//333
	Scale 0.35
	+NOGRAVITY +friendly
	States
	{
	Spawn:
		TNT1 A 1
		loop
	Death:
		TNT1 A 0
		TNT1 A 0 A_Jump(64, 2)
		ZAP7 A 1 A_customMissile("MagicLightning",0,0,0,CMF_TRACKOWNER, 1)//A_SpawnItem("MagicLightning")//This Function makes a Trap
		ZAP7 AB 3 bright
		ZOT3 AB 3 bright
		ZAP1 FEDCBA 3 bright
		Stop
	}
}
//Lighting
//ACTOR MagicLightning
//{
//	Radius 4 Height 6 Speed 20
//	Damage 3
//	RENDERSTYLE ADD
//	ALPHA 0.67
//	scale 0.35
//	PROJECTILE
//	+THRUGHOST
//	+SEEKERMISSILE
////	SeeSound "monster/harplit1"
////	DeathSound "monster/lighthit"
//	States
//	{
//	Spawn:
//		ZAP6 A 1
//		ZAP6 A 0 bright A_spawnItem ("MagicLightningFX",0,0)
//		ZAP6 A 1 bright A_SeekerMissile(360, 40)//A_SeekerMissile(360, 40, SMF_LOOK, 255, 10)//SMF_LOOK | SMF_PRECISE //Fix
//		ZAP6 B 0 bright A_spawnItem ("MagicLightningFX",0,0)
//		ZAP6 B 1 bright A_SeekerMissile(360, 40)//A_SeekerMissile(360, 40, SMF_LOOK, 255, 10) //Fix
//		ZAP6 C 0 bright A_spawnItem ("MagicLightningFX",0,0)
//		ZAP6 C 1 bright A_SeekerMissile(360, 40)//A_SeekerMissile(360, 40, SMF_LOOK, 255, 10) //Fix
//		loop
//	Death:
//		TNT1 A 0
//		TNT1 A 0 A_Jump(64, 2)
//		TNT1 A 0 A_customMissile("MagicLightning",0,0,0,CMF_TRACKOWNER, 1)
//		ZAP7 AB 3 bright
//		ZOT3 AB 3 bright
//		ZAP1 FEDCBA 3 bright
//		stop
//	}
//}
ACTOR MagicLightning : MageStaffFX2
{
	Radius 4 Height 6 Speed 20
	Damage 4
	RENDERSTYLE ADD
	ALPHA 0.67
	scale 0.35
  +MISSILE -FIREDAMAGE +FRIENDLY +NOGRAVITY -EXTREMEDEATH +NOTELEPORT +FOILINVUL +NOBLOCKMAP +ACTIVATEIMPACT +ACTIVATEPCROSS +DROPOFF +RANDOMIZE +ROCKETTRAIL +SEEKERMISSILE
  ReactionTime 2000
//	SeeSound "monster/harplit1"
//	DeathSound "monster/lighthit"
	States
	{
  Spawn:
    TNT1 A 0 A_CountDown
    TNT1 A 0 A_LookEx(2,0,60,0,360,"See")
		ZAP6 A 0 bright A_spawnItem ("MagicLightningFX",0,0)
    ZAP6 A 1 bright A_MStaffTrack
		ZAP6 A 0 bright A_spawnItem ("MagicLightningFX",0,0)
    ZAP6 B 1 bright A_MStaffTrack
		ZAP6 A 0 bright A_spawnItem ("MagicLightningFX",0,0)
    ZAP6 C 1 bright A_MStaffTrack
    Loop
  See:
    TNT1 A 0 A_CustomMeleeAttack(random(1,4)*2,"none","none")
    TNT1 A 0 A_ClearTarget
    TNT1 A 0 A_ChangeFlag("FRIENDLY",0)
    TNT1 A 0 A_LookEx(0,0,0,0,360,"Death")
  Death:
    TNT1 A 0 A_ChangeFlag("NOCLIP",1)
		ZAP7 A 1
//		TNT1 A 0 A_Jump(64, 2)
		ZAP7 A 2 A_customMissile("MagicLightning2",0,0,0,CMF_TRACKOWNER, 1)
		ZAP7 B 3 bright
//		ZOT3 AB 3 bright
//		ZAP1 FEDCBA 3 bright
		stop
//    TNT1 A 0 A_ChangeFlag("ROCKETTRAIL",0)
//    TNT1 A 0 A_ChangeFlag("NOCLIP",1)
//    TNT1 A 0 A_Scream
//    TNT1 A 0 Radius_Quake(3, 28, 1, 4, 0)
//    TNT1 A 0 A_Explode(230, 192)
//    TNT1 A 0 A_SpawnItemEx("SFX_RocketExplosion", 0, 0, 0, 0, 0, 1, 0, 128 | SXF_NOCHECKPOSITION, 0)
//    TNT1 A 20
    Stop
	}
}
ACTOR MagicLightning2 : MagicLightning
{
	States
	{
  Death:
    TNT1 A 0 A_ChangeFlag("NOCLIP",1)
		TNT1 A 0
		TNT1 A 0 A_Jump(64, 2)
		TNT1 A 0 A_customMissile("MagicLightning2",0,0,0,CMF_TRACKOWNER, 1)
		ZAP7 AB 3 bright
		stop
	}
}
ACTOR MagicLightningFX
{   
	Radius 3 Height 3 Speed 0
	PROJECTILE
	RENDERSTYLE ADD
	scale 0.35
	ALPHA 0.67
	States
	{
	Spawn:
		ZAP6 ABCABCABCABC 2 bright
		Stop 
	}
}
//  ********************************************************
//  ***  Weapon: Thunder                                 ***
//  ********************************************************
//DemonicEnergyProjector
ACTOR MagichandLightingThunderShot //normal fire
{
	PROJECTILE
	Damage 0
	Radius 8 Height 8 Speed 160//333
	Scale  1.0
	+NOGRAVITY +friendly
	States
	{
		Spawn:
			TNT1 A 1
			loop
		Death:
			TNT1 A 1 A_SpawnItem("MagichandLightingThunderFX")
//			TNT1 A 1 A_SpawnItemEx("MagichandLightingThunderFX", 0, 0, 128, 0, 0, 0, 0, SXF_NOCHECKPOSITION)
			Stop
	}
}
Actor MagichandLightingThunderFX : ThunderFX
{
	States
	{
	Spawn:
		TNT1 A 0
		TNT1 A 0 A_Explode(600, 138, 0)
		goto Death
	}
}
