//  ********************************************************
//  ***  Monster: Zombie (Blood)                         ***
//  ***  Modified By: Cobalt and Butcher                 ***
//  ********************************************************
actor ZombieBlood 3031
{
	Tag "Zombie"
	Scale 0.48
	Health 80 gibhealth 120
	Radius 20
	Height 56
	Speed 12
	PainChance 50
	Mass 400
	MONSTER 
	+FLOORCLIP +LOOKALLAROUND +QUICKTORETALIATE +FASTER +FASTMELEE
//	seesound "monster/zombieblood/see"
	painsound "monster/zombieblood/pain"
	deathsound "monster/zombieblood/death"
	MeleeSound "monster/zombieblood/attak"
	activesound "monster/zombieblood/walk"
	Obituary "%o was smashed by a Zombie. (you lost your brain)"
	MeleeDamage 8
	States
	{
		Spawn:
			TNT1 A 0 A_UnSetShootable
			TNT1 A 0 A_UnsetSolid
			TNT1 A 10 A_Look
			Loop
		See:
			TNT1 A 0
			TNT1 G 1 A_JumpIfCloser(350, 1)
			goto Spawn
			ZOM0 A 1 A_PlaySound("monster/zombieblood/see")
			ZOM0 A 0 A_SetSolid
			ZOM0 A 4 A_SetShootable
			ZOM0 BCDEFGHIJ 4 //awake
			ZOM1 H 3 //stay a while
			ZOM0 A 0
			ZOM1 ABCDEF 3 A_Chase
			goto See + 15
		Melee:
			ZOM1 I 1
			ZOM1 I 3 A_FaceTarget
			ZOM1 J 0 //A_PlayWeaponSound("weapons/gswing")
			ZOM1 JK 3
			ZOM1 L 3 A_MeleeAttack
			ZOM1 MN 3
			Goto See + 15
		Pain:
			ZOM1 G 2
			ZOM1 G 2 A_Pain
			Goto See + 15
		Death:
			NULL A 0 A_KillMaster
			ZOM2 A 0
			ZOM2 A 6
			ZOM2 B 6 A_Scream
			ZOM2 C 6
			ZOM2 D 6 A_Fall

//			ZOM2 A 0 A_Jump(64, 8) // chance for -> Death forever
//			ZOM2 E 35 A_ChangeFlag("NOBLOCKMAP", 0)//A_SetShootable//A_SetSolid
//			ZOM2 FGHIJK 3 HealThing(20)
//			goto See + 15

			ZOM2 E 0 A_Jump(128, 2) // chance for -> Death forever
			ZOM2 E 0 A_SpawnItem("BloodZombieHealer",0,0)
			ZOM2 E 0 A_NoBlocking
			ZOM2 E -1
			Stop
		XDeath:
			NULL A 0 A_KillMaster
			TNT1 A 0 A_SpawnDebris("rGib1",0) //(Human hand)
			TNT1 A 0 A_SpawnDebris("rGib2",0) //(Human arm)
			TNT1 A 0 A_SpawnDebris("rGib3",0) //(eyeball)
			TNT1 A 0 A_SpawnDebris("rGib3",0) //(eyeball)
			TNT1 A 0 A_SpawnDebris("rGib19",0) //(brain)
			TNT1 A 0 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
			TNT1 A 0 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
			TNT1 A 0 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
			TNT1 A 0 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
			Stop
		Burn: 
			NULL A 0 A_KillMaster
			TNT1 A 0 //A_PlaySound("human/burndeath")
			TNT1 A 0 A_SpawnItemEx("Human_Burn", 0, 0, 0, 0, 0, 0, 0, 32, 0)
			Stop
		Raise:
			ZOM2 F 1 A_PlayWeaponSound("monster/zombieblood/rise")
			ZOM2 F 1 A_KillChildren
			ZOM2 FGHIJK 3
			Goto See + 15
	}
}
//  ********************************************************
//  ***  Monster: Zombie (Blood) on ground               ***
//  ***  Modified By: Cobalt and Butcher                 ***
//  ********************************************************
actor ZombieBloodOnFloor : ZombieBlood 3033
{
	-LOOKALLAROUND +FASTER +FASTMELEE
	seesound "monster/zombieblood/see"
	painsound "monster/zombieblood/pain"
	deathsound "monster/zombieblood/death"
	MeleeSound "monster/zombieblood/attak"
	activesound "monster/zombieblood/walk"
	Obituary "%o was smashed by a zombie. (you lost your brain)"
	MeleeDamage 8
	States
	{
		Spawn:
			ZOM1 H 10 A_Look
			Loop
		See:
			ZOM1 ABCDEF 3 A_Chase
			loop
		Melee:
			ZOM1 I 1
			ZOM1 I 3 A_FaceTarget
			ZOM1 J 0 //A_PlayWeaponSound("weapons/gswing")
			ZOM1 JK 3
			ZOM1 L 3 A_MeleeAttack
			ZOM1 MN 3
			Goto See
		Pain:
			ZOM1 G 2
			ZOM1 G 2 A_Pain
			Goto See
		Raise:
			ZOM2 F 1 A_PlayWeaponSound("monster/zombieblood/rise")
			ZOM2 F 1 A_KillChildren
			ZOM2 FGHIJK 3
			Goto See
	}
}
ACTOR BloodZombieHealer
{
	Health 1
	Radius 0
	Height 1
	Mass 1000
	Speed 0
	Damage 0
	MeleeDamage 0
//	RENDERSTYLE NONE
	PAINCHANCE 0
	ReactionTime 8
	MONSTER
	-COUNTKILL +DONTGIB +NOTARGET +INVULNERABLE +NOCLIP +NONSHOOTABLE +LOOKALLAROUND
	States
	{
	Spawn: 
		TNT1 A 0
		TNT1 A 0
		TNT1 AA 10 A_Look 
		Loop 
	See: 
		TNT1 A 105 A_Jump(32, 1)
		Loop 
		TNT1 AAAA 3 A_VileChase
		TNT1 A 0 A_CountDown
		Loop 
	Heal:
		TNT1 A 1
		Goto Death 
	Pain: 
		TNT1 A 3  
		TNT1 A 3 A_Pain 
		Goto See
	Death: 
		TNT1 A 4 A_Noblocking
		TNT1 A 5 A_Scream 
		TNT1 AAAA 4
		Stop 
	}
}
