//  ********************************************************
//  ***  Monster: PyroDemon                              ***
//  ***  By: Maelstrom                                   ***
//  ***  Modified By: Cobalt and Butcher                 ***
//  ********************************************************
ACTOR PyroDemon 3027
{
	Tag "Pyro Demon"
	Scale 1.2
	Health 1250
	Radius 30
	Height 72
	Mass 1000
	Speed 8
	PainChance 20
	MONSTER
	MeleeDamage 20
	OBITUARY "%o was burnt to a crisp by a Pyro Demon"
	HITOBITUARY "%o was melted my a Pyro Demon"
	BloodColor "ff 96 23"
//	Bloodcolor "75 25 00"
	+FloorClip +MissileMore +DontHurtSpecies +FIRERESIST //+NoRadiusDMG +NoTarget
	SEESOUND "pyro/see"
	PAINSOUND "pyro/pain"
	DEATHSOUND "pyro/death"
	ACTIVESOUND "pyro/idle"
	states
	{
	Spawn:
		PYRO AB 10 bright A_Look
		Loop 
	See:
		PYRO AA 3 bright A_Chase
		PYRO A 0 A_CustomMissile("WalkFire",0,0,0,0)
		PYRO BB 3 bright A_Chase
		PYRO B 0 A_CustomMissile("WalkFire",0,0,0,0)
		PYRO CC 3 bright A_Chase
		PYRO C 0 A_CustomMissile("WalkFire",0,0,0,0)
		PYRO DD 3 bright A_Chase
		PYRO D 0 A_CustomMissile("WalkFire",0,0,0,0)
		Loop 
	Missile:
		PYRO B 0 A_Jump(32,29)
		PYRO B 0 A_Jump(32,20)
		PYRO EF 8 BRIGHT A_FaceTarget 
		PYRO G 0 BRIGHT A_CustomMissile ("FireDemonFireShot",36,16,0,0)
		PYRO G 0 BRIGHT A_CustomMissile ("FireDemonFireShot",36,16,-4,0)
		PYRO G 3 BRIGHT A_CustomMissile ("FireDemonFireShot",36,16,4,0)
		PYRO H 3 BRIGHT
		PYRO H 0 A_Jump(32,8)
		PYRO IJ 8 BRIGHT A_FaceTarget 
		PYRO K 0 BRIGHT A_CustomMissile ("FireDemonFireShot",36,-16,0,0)
		PYRO K 0 BRIGHT A_CustomMissile ("FireDemonFireShot",36,-16,-4,0)
		PYRO K 3 BRIGHT A_CustomMissile ("FireDemonFireShot",36,-16,4,0)
		PYRO L 3 BRIGHT
		PYRO L 0 A_Jump(32,1)
		Goto See
		PYRO MN 8 BRIGHT A_FaceTarget
		PYRO O 4 BRIGHT A_CustomMissile ("PyroBlast",36,0,0,0)
		PYRO P 4 BRIGHT
		Goto See
		PYRO MN 8 BRIGHT A_FaceTarget
		PYRO O 4 BRIGHT A_CustomMissile ("RainCometNull",36,0,0,0)
		PYRO O 4 BRIGHT A_CustomMissile ("RainCometNull",36,0,90,0)
		PYRO O 4 BRIGHT A_CustomMissile ("RainCometNull",36,0,180,0)
		PYRO O 4 BRIGHT A_CustomMissile ("RainCometNull",36,0,270,0)
		PYRO P 4 BRIGHT
		Goto See
		PYRO O 1 bright A_FaceTarget
		PYRO O 0
		PYRO O 0 //A_Mushroom ("Pyroball",16)
		PYRO O 3 
		PYRO P 3 BRIGHT
		PYRO A 0 A_UnSetShootable
		PYRO A 1 bright A_PlaySound("pyro/tele")
		PYRO A 1 bright A_SetTranslucent(0.90)
		PYRO A 1 bright A_SetTranslucent(0.80)
		PYRO A 1 bright A_SetTranslucent(0.70)
		PYRO A 1 bright A_SetTranslucent(0.60)
		PYRO A 1 bright A_SetTranslucent(0.50)
		PYRO A 1 bright A_SetTranslucent(0.40)
		PYRO A 1 bright A_SetTranslucent(0.30)
		PYRO A 1 bright A_SetTranslucent(0.20)
		PYRO A 1 bright A_SetTranslucent(0.10)
		NULL AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA 0 A_Wander
		NULL A 0 A_Jump(128,25)
		NULL AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA 0 A_ExtChase(0,0,1,1)
		PYRO A 1 bright A_PlaySound("pyro/tele")
		PYRO A 1 bright A_SetTranslucent(0.10)
		PYRO A 1 bright A_SetTranslucent(0.20)
		PYRO A 1 bright A_SetTranslucent(0.30)
		PYRO A 1 bright A_SetTranslucent(0.40)
		PYRO A 1 bright A_SetTranslucent(0.50)
		PYRO A 1 bright A_SetTranslucent(0.60)
		PYRO A 1 bright A_SetTranslucent(0.70)
		PYRO A 1 bright A_SetTranslucent(0.80)
		PYRO A 1 bright A_SetTranslucent(0.90)
		PYRO A 1 bright A_SetTranslucent(1.0)
		PYRO A 0 bright
		PYRO O 0 //A_Mushroom ("Pyroball",16)
		PYRO A 0 A_SetShootable
		Goto See
	Pain: 
		PYRO Q 2 bright
		PYRO Q 2 bright A_Pain 
		Goto See 
	Death: 
		PYRO R 20 BRIGHT A_Scream
		PYRO S 20 BRIGHT
		PYRO T 20 BRIGHT 
		PYRO U 20 BRIGHT A_NoBlocking 
		PYRO VW 6 BRIGHT 
		PYRO X 6 BRIGHT
		PYRO Y 3 BRIGHT 
		PYRO Z -1 BRIGHT
		Stop
	} 
}
//  ********** Fireball medium **********
//  PyroDemon
ACTOR FireDemonFireShot
{
	Radius 3
	Height 3
	Speed 15
	Damage 12
	PROJECTILE
	RENDERSTYLE ADD
	ALPHA 0.67
	+FIREDAMAGE +BLOODLESSIMPACT
	MissileType FireTail
	SeeSound "pyro/flame"
	DeathSound "imp/shotx"
	States
	{
	Spawn:
		FSHT A 1 Bright A_CustomMissile("FireDemonFireTail",0,0,0,0)
		FSHT A 1 Bright A_CustomMissile("FireDemonFireTail",0,0,0,0)
		FSHT A 1 Bright A_CustomMissile("FireDemonFireTail",0,0,0,0)
		FSHT A 1 Bright A_CustomMissile("FireDemonFireTail",0,0,0,0)
		FSHT A 1 Bright A_CustomMissile("FireDemonFireTail",0,0,0,0)
		FSHT A 1 Bright A_CustomMissile("FireDemonFireTail",0,0,0,0)
		Loop
	Death:
		FSHT A 0 Bright
		FSHT B 0 Bright
		FSHT B 3 Bright
		FSHT C 3 Bright
		FSHT D 3 Bright
		FSHT E 3 Bright
		Stop
	}
}
actor FireDemonFireTail
{
	PROJECTILE
	RENDERSTYLE ADD
	+NOCLIP
	ALPHA 0.4
	States
	{
	Spawn:
		FRTB ABCDEFGHI 1 Bright
		Stop
	}
}
//  ********** Fireball big **********
//  PyroDemon
ACTOR PyroBlast
{
	PROJECTILE
	+SeekerMissile +NoGravity +BLOODLESSIMPACT
	RENDERSTYLE Add
	Alpha 0.4
	SEESOUND "pyro/blast"
	DEATHSOUND "imp/shotx"
	Speed 17
	Height 10
	Radius 10
	states
	{
	Spawn:
		SBLL ABCDEFGHIJ 1 BRIGHT A_CustomMissile("FireDemonFireTail",0,0,0,0)
		SBLL A 0 BRIGHT A_SeekerMissile(0,2)
		Goto Spawn+1
	Death:
		SBLL K 0 A_CustomMissile("FirebombExplosion1",1,0,45)
		SBLL K 0 A_CustomMissile("FirebombExplosion1",1,0,135)
		SBLL K 0 A_CustomMissile("FirebombExplosion1",1,0,225)
		SBLL K 0 A_CustomMissile("FirebombExplosion1",1,0,315)
		SBLL LMNOPQRSTUVW 1 BRIGHT
		Stop
	}
}
ACTOR FirebombExplosion1
{
	Scale 0.5
	Radius 11 Height 8 Speed 4
	Damage 6
	+NOBLOCKMAP +DROPOFF +MISSILE +ACTIVATEIMPACT +ACTIVATEPCROSS +BLOODLESSIMPACT
	ExplosionDamage 64 ExplosionRadius 112
	Obituary "%o was killed by a Firebomb explosion."
	States
	{
	Spawn:
		CANE A 1 Bright
		Loop
	Death:
		TNT1 A 0
		TNT1 A 0 A_PlaySound("imp/shotx"/* "pyro/blastexplosion" */)
		CANE A 2 Bright A_Explode
		CANE BCDEFGHIJK 2 Bright
		Stop
	}
}
//  ********** Fire on Floor medium (no damage) **********
//  PyroDemon
ACTOR WalkFire
{
	+NOCLIP +MISSILE +DROPOFF +RANDOMIZE +BLOODLESSIMPACT
	Scale 1.5
	Speed 1
	RENDERSTYLE ADD
	ALPHA 0.67
	States
	{
	Spawn:
		NULL A 8
		FRTF A 3 Bright
		FRTF A 0 
		FRTF B 3 Bright
		FRTF B 0 
		FRTF C 3 Bright
		FRTF C 0 
		FRTF C 0 
		FRTF C 0 A_Jump(191,4)
		FRTF C 0 A_CustomMissile("WalkFire_nolight", 0, 24, 0)
		FRTF C 0 A_CustomMissile("WalkFire", 0, 0, 0)
		FRTF C 0 A_CustomMissile("WalkFire_nolight", 0, -24, 0)
		FRTF DEFGHIJKLMNO 3 Bright
		Stop
	}
}
ACTOR WalkFire_nolight : WalkFire
{
}
//  ********** Meteor Rain medium (one direktion) **********
//  PyroDemon
ACTOR RainCometNull
{
	Radius 0
	Height 0
	Speed 8
	PROJECTILE
	+FloorClip
	+Ripper
	+DoomBounce
	+CeilingHugger
	+DontHurtSpecies
	states
	{
	Spawn:
		TNT1 A 0 A_Jump(5,8)
		TNT1 AAAAAA 1 A_Wander
		TNT1 A 8 A_CustomMissile("FallingComet",-24,random(0,128),random(0,360),2,random(1,89))
		Loop
	Death:
		TNT1 A 0
		Stop
	}
}
ACTOR FallingComet
{
	Radius 6 Height 8 Speed 5
	Damage 5
	Scale 0.55
	PROJECTILE
	SEESOUND "pyro/comet"
	DEATHSOUND "pyro/cometdeath"
	MissileType FireTail
	MissileHeight 0
	-NoGravity -Float
	+FloorClip +DontHurtSpecies  +SpawnCeiling
	states
	{
	Spawn:
		COMT AAAABBBBCCCC 1 BRIGHT A_MissileAttack
		Loop
	Death:
		COMT D 3 BRIGHT A_CustomMissile("PDCometDeathGlow", 0, 0, 0)
		COMT E 3 BRIGHT A_Explode(60,128,0)
		COMT E 0 A_CustomMissile("PDCometDeath", 0, 0, 0)
		Stop
	}
}
//  ********** CometDeathGlow **********
//  ~Afrit~, PyroDemon
actor PDCometTail // :
{
	PROJECTILE
	RENDERSTYLE ADD
	+NOCLIP
	ALPHA 0.4
	States
	{
	Spawn:
		FRTB ABCDEFGHI 1 Bright
		Stop
	}
}
actor PDCometDeathGlow : PDCometTail //CometDeathGlow
{
	Scale 2.0
	Alpha 0.6
	States
	{
	Spawn:
		FRTB ABCDEFGHI 3 Bright
		Stop
	}
}
//  ********** CometDeath **********
//  ~Afrit~, PyroDemon
//  Comet, FallingComet, OrbitComet
actor PDCometDeath//CometDeath
{
	PROJECTILE
	RENDERSTYLE ADD
	+NOCLIP
	ALPHA 0.7
	States
	{
	Spawn:
		COMT FGHI 3 Bright
		Stop
	}
}
