//  ********************************************************
//  ***  Monster: Imp Warlord                            ***
//  ***  By: Espi                                        ***
//  ***  Additional scripting By: Nanami                 ***
//  ***  Modified By: Cobalt and Butcher                 ***
//  ********************************************************
actor ImpWarlord 3105
{
	Tag "Imp Warlord"
	Health 120 gibhealth 120
	Radius 20 Height 56 Speed 9 PainChance 128
	MONSTER 
	+FLOORCLIP
	SeeSound "imp/sight"
	PainSound "imp/pain"
	DeathSound "imp/death"
	ActiveSound "imp/active"
	MeleeSound "implord/macehit"
	Obituary "%o couldn't run from the imp warlord's fireball."
	HitObituary "%o was beaten to death by an imp warlord."
	MeleeDamage 4
	States
	{
	Spawn:
		WARI AB 10 A_Look
		Loop
	See:
		WARI AABBCCDD 3 A_Chase
		Loop
	Melee:
		WARI E 6 A_FaceTarget
		WARI E 0 A_PlaySound("implord/maceswing")
		WARI F 4 A_FaceTarget
		WARI G 5 A_MeleeAttack
		Goto See
	Missile:
		WARI E 0 A_Jump(38,23)  //20% chance: jump to familiar drop
		WARI E 0 A_Jump(77,2)   //30% chance: jump to heat seekers
		WARI E 0 A_Jump(128,11) //50% chance: jump to green fireballs
		Goto Missile+28         //Otherwise : jump to red fireball
		WARI I 0 A_SetInvulnerable
		WARI I 6 A_FaceTarget
		WARI J 0 A_PlaySound("implord/shieldshot")
		WARI J 6 bright A_FaceTarget
		WARI J 0 A_Jump(128,4)
		WARI K 0 bright A_CustomMissile("YellowSkullSeeker", 32, 0, -45)
		WARI K 6 bright A_CustomMissile("YellowSkullSeeker", 32, 0, 45)
		WARI K 0 A_UnSetInvulnerable
		Goto See
		WARI K 6 bright A_CustomMissile("YellowSkullSeeker", 32, 0, 0)
		WARI K 0 A_UnSetInvulnerable
		Goto See
		WARI L 7 A_FaceTarget
		WARI M 0 A_PlaySound("implord/maceswing")
		WARI M 5 A_FaceTarget
		WARI M 0 A_PlayWeaponSound("imp/attack")
		WARI M 0 A_Jump(128,3)
		WARI N 0 A_CustomMissile("GreenPoisonBall", 40, 0, -8, 1)
		WARI N 0 A_CustomMissile("GreenPoisonBall", 24, 0, 8, 1)
		WARI N 0 A_CustomMissile("GreenPoisonBall", 32, 0, 0, 1)
		WARI N 0 A_CustomMissile("GreenPoisonBall", 36, 0, -4, 1)
		WARI N 6 A_CustomMissile("GreenPoisonBall", 28, 0, 4, 1)
		Goto See
		WARI GF 8 A_FaceTarget
		WARI F 0 A_Jump(128,2)
		WARI E 8 A_CustomMissile("FamiliarSpawner", 32, 0, -30)
		Goto See
		WARI E 8 A_CustomMissile("FamiliarSpawner", 32, 0, 30)
		Goto See
		WARI O 0 A_Jump(128,5)
		WARI O 7 A_FaceTarget
		WARI P 0 A_PlaySound("implord/maceswing")
		WARI P 5 A_FaceTarget
		WARI Q 6 A_CustomMissile("RedSkullBall", 32, 0, 0)
		WARI O 7 A_FaceTarget
		WARI P 0 A_PlaySound("implord/maceswing")
		WARI P 5 A_FaceTarget
		WARI Q 6 A_CustomMissile("RedSkullBall", 32, 0, 0)
		Goto See
	Pain:
		WARI H 0 A_Jump(128,2)
		WARI H 8 A_Pain
		Goto See
		WARI I 1
		WARI I 0 A_SetInvulnerable
		WARI IIIIII 4 A_FaceTarget
		WARI I 0 A_Jump(160,5)
		WARI IIII 4 A_FaceTarget
		Goto Pain+4
		WARI I 0 A_UnSetInvulnerable
		Goto See
	Death:
		NULL A 0 A_KillMaster
		WARI R 0 A_CustomMissile("WarlordMace", 32, 0, -90)
		WARI R 0 A_CustomMissile("WarlordShield", 32, 0, 90)
		WARI R 8
		WARI S 8 A_Scream
		WARI T 6
		WARI U 6 A_Fall
		WARI V -1
		Stop
	XDeath:
		NULL A 0 A_KillMaster
		NULL A 0 A_SpawnDebris("rGib5",0) //(Imp hand [skin brown])
		NULL A 0 A_SpawnDebris("rGib5",0) //(Imp hand [skin brown])
		NULL A 0 A_SpawnDebris("rGib3",0) //(eyeball)
		NULL A 0 A_SpawnDebris("rGib3",0) //(eyeball)
		NULL A 0 A_SpawnDebris("rGib19",0) //(brain)
		NULL A 0 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
		NULL A 0 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
		NULL A 0 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
		NULL A 0 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
		WARI R 0 A_CustomMissile("WarlordMace", 32, 0, -90)
		WARI R 0 A_CustomMissile("WarlordShield", 32, 0, 90)
		Stop
	Burn: 
		NULL A 0 A_KillMaster
		NULL A 0 A_PlaySound("imp/death")
		NULL A 0 A_SpawnItemEx("Human_Burn", 0, 0, 0, 0, 0, 0, 0, 32, 0)
		WARI R 0 A_CustomMissile("WarlordMace", 32, 0, -90)
		WARI R 0 A_CustomMissile("WarlordShield", 32, 0, 90)
		Stop
	Raise:
		WARI VU 8
		WARI TSR 6
		Goto See
	}
}
actor WarlordShield
{
	+DOOMBOUNCE
	Speed 5
	States
	{
		Spawn:
			WLI1 ABCDEF 5
			WLI1 G -1
			Stop
	}
}
actor WarlordMace
{
	+DOOMBOUNCE
	Speed 4
	States
	{
		Spawn:
			WLI2 ABCDEF 5
			WLI2 G -1
			Stop
	}
}
//  ********** Yellow Head [seeker] medium **********
//  ImpWarlord
actor YellowSkullSeeker
{
	Radius 8 Height 6 Speed 9
	Damage 5
	+SEEKERMISSILE
	PROJECTILE
	RENDERSTYLE ADD
	scale 0.67
	ALPHA 0.67
	DeathSound "implord/shieldshothit"
	States
	{
		Spawn:
			WLP2 ABCD 3 Bright A_SeekerMissile (5,10)
			Loop
		Death:
			WLP2 EFG 4 Bright
			Stop
	}
}
//  ********** PoisonBall small (green) **********
//  ImpWarlord
actor GreenPoisonBall
{
	Radius 8 Height 6 Speed 10
	Damage 3
	PROJECTILE
	RENDERSTYLE ADD
	ALPHA 0.67
	DeathSound "imp/shotx"
	States
	{
		Spawn:
			WLP1 ABCD 4
			Loop
		Death:
			WLP1 EFGH 4
			Stop
	}
}
//  ********** Flying Burning Skull small (red) **********
//  ImpWarlord
actor RedSkullBall
{
	Radius 8 Height 6 Speed 15
	Damage 6
	PROJECTILE
	RENDERSTYLE ADD
	ALPHA 0.67
	SeeSound "imp/attack"
	DeathSound "imp/shotx"
	States
	{
		Spawn:
			WLP4 ABCB 4 bright
			Loop
		Death:
			WLP4 DEFG 4 bright
			Stop
	}
}
//  ********** Spawns a BatFamilar **********
//  ImpWarlord
ACTOR FamiliarSpawner
{
	+MISSILE +DOOMBOUNCE
	Speed 8
	Damage 0
	DeathSound "implord/familiarspawn"
	States
	{
		Spawn:
			WLP3 ABCD 4
			Loop
		Death:
			WLP3 E 4
			WLP3 F 6
			WLP3 G 8 A_CustomMissile("BatFamiliar", 32, 0, 0)
			WLP3 H 350
			Stop
	}
}
