//  ********************************************************
//  ***  Monster: Big Dragon from Doom64                 ***
//  ***  By: Cobalt and Butcher                          ***
//  ********************************************************
ACTOR Gargantuan 3015
{
	Tag "Gargantuan"
	Scale 0.5
	Gibhealth 350
	+MISSILEMORE +DONTHURTSPECIES
	obituary "%o was smitten by the meat beast."
	hitobituary "%o got too close to the meat beast."
	health 800
	radius 31 height 64 speed 16 mass 400
	MaxTargetRange 1200
	painchance 128
	seesound "monsters/dragonsee"
	painsound "monsters/dragonpain"
	deathsound "monsters/dragondie"
	activesound "monsters/dragonsee"
	MONSTER
	+FLOAT
	+NOGRAVITY
	states
	{
		Spawn:
			MOTH ABCD 4 A_Look
			loop
		See:
			MOTH ABCD 4 A_ExtChase(0, 1, 1, 0)
			loop
		Melee:
		Missile:
			MOTH E 0 A_JumpIfCloser(300, "MissileSpit")
			MOTH E 0 A_JumpIfCloser(600, "Missile1")
			MOTH E 0 A_JumpIfCloser(900, "Missile2")
			MOTH E 0 A_JumpIfCloser(1200, "Missile3")
			goto See
		Missile1:
			MOTH E 4 A_FaceTarget
			MOTH F 0 A_PlaySound ("Gargantuan/SlimeBall/Shoot")
			MOTH F 4 A_ThrowGrenade("GargantuanShot", 24, 16, 0.33)
			MOTH G 4 A_FaceTarget
			goto See
		Missile2:
			MOTH E 4 A_FaceTarget
			MOTH F 0 A_PlaySound ("Gargantuan/SlimeBall/Shoot")
			MOTH F 4 A_ThrowGrenade("GargantuanShot", 24, 24, 0.33)
			MOTH G 4 A_FaceTarget
			goto See
		Missile3:
			MOTH E 4 A_FaceTarget
			MOTH F 0 A_PlaySound ("Gargantuan/SlimeBall/Shoot")
			MOTH F 4 A_ThrowGrenade("GargantuanShot", 24, 36, 0.33)
			MOTH G 4 A_FaceTarget
			goto See
		MissileSpit:
			MOTH E 8 A_FaceTarget
			MOTH F 8 A_PlaySound ("Gargantuan/SlimeBall/Shoot")
			MOTH F 0 A_CustomMissile ("BloodSSlimeBall1", 40, 0, random(-10,10), 2, random(10,20))
			MOTH F 0 A_CustomMissile ("BloodSSlimeBall2", 40, 0, random(-10,10), 2, random(10,20))
			MOTH F 0 A_CustomMissile ("BloodSSlimeBall3", 40, 0, random(-10,10), 2, random(10,20))
			MOTH F 0 A_CustomMissile ("BloodSSlimeBall4", 40, 0, random(-10,10), 2, random(10,20))
			MOTH F 0 A_CustomMissile ("BloodSSlimeBall5", 40, 0, random(-10,10), 2, random(10,20))
			MOTH G 8
			goto See
		Pain:
			MOTH H 16 A_Pain
			goto See
		Death:
		XDeath:
			NULL A 0 A_KillMaster
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall1", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall2", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall3", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall4", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall5", 40, 0, random(0,360), 2, random(10,20))
			MOTH I 4 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
			MOTH I 4 A_SpawnItem("rxGibGenerator_m",0,0,0,0)
			MOTH J 4 A_Scream
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall1", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall2", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall3", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall4", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall5", 40, 0, random(0,360), 2, random(10,20))
			MOTH K 4 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
			MOTH L 4 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
			MOTH L 4 A_SpawnItem("rxGibGenerator_m",0,0,0,0)
			MOTH M 4 A_SpawnItem("rxGibGenerator_m",0,0,0,0)
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall1", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall2", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall3", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall4", 40, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall5", 40, 0, random(0,360), 2, random(10,20))
			MOTH M 4 A_SpawnItem("rxGibGenerator_s",0,0,0,0)
			MOTH N 4 A_SpawnItem("rxGibGenerator_m",0,0,0,0)
			MOTH N 4 A_SpawnItem("rxGibGenerator_m",0,0,0,0)
			MOTH O 4 A_NoBlocking
			stop
		Raise:
			MOTH M 8 A_UnSetFloorClip
			MOTH LKJIHG 8
			goto See
	}
}
//  ********** MeatBall **********
//  Dragon_big
ACTOR GargantuanShot // "DRA1" used by: MagicHandsFireShot1 (Fleisch)
{
	Decal BloodSplat
	Translation "0:255=[160,0,0]:[32,0,0]"
	Scale 0.18
	Radius 8 Height 6 Speed 18 FastSpeed 18 mass 1
	Damage 12
	RENDERSTYLE NORMAL
	PROJECTILE
	States
	{
		Spawn:
			DRA1 ABCDEF 2 A_LowGravity
			Loop
		Death:
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall1", 0, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall2", 0, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall3", 0, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall4", 0, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall5", 0, 0, random(0,360), 2, random(10,20))
			TNT1 A 0 A_CustomMissile ("BloodSSlimeSplatterBall5", 0, 0, random(0,360), 2, random(10,20))
			SKUX A 1 A_SpawnItem("NashGore_FlyingBlood",0,0,0,1)
//			SKUX ABCD 1
//			SKUX E 1 A_PlaySound("monsters/firegargbolt")
//			SKUX FGHIJ 1 A_SpawnItem("NashGore_FlyingBlood",0,0,0,1)
			Stop
	}
}
//BloodSlimeBalls
actor BloodSSlimeBall1 : DoomImpBall
{
	radius 4 height 4 speed 14 FastSpeed 14
	damage 8
	seesound none
	RENDERSTYLE NORMAL Alpha 1
	deathsound "Gargantuan/slimeball/splat"
	Translation "0:255=[160,0,0]:[32,0,0]"
	scale 0.5
	-NOGRAVITY
	Decal BloodSplat
	states
	{
	Spawn:
		BOGY ABC 2 bright
		loop
	Death:
		BOGY D 0 bright A_NoGravity
		BOGY DEF 4 bright
		stop
	}
}
actor BloodSSlimeBall2 : BloodSSlimeBall1
{
	speed 16 FastSpeed 16
}
actor BloodSSlimeBall3 : BloodSSlimeBall1
{
	speed 18 FastSpeed 18
}
actor BloodSSlimeBall4 : BloodSSlimeBall1
{
	speed 20 FastSpeed 20
}
actor BloodSSlimeBall5 : BloodSSlimeBall1
{
	speed 22 FastSpeed 22
}
//SplatterBall
actor BloodSSlimeSplatterBall1 : BloodSSlimeBall1
{
	Scale 0.33
	speed 1 FastSpeed 1
}
actor BloodSSlimeSplatterBall2 : BloodSSlimeSplatterBall1
{
	speed 2 FastSpeed 2
}
actor BloodSSlimeSplatterBall3 : BloodSSlimeSplatterBall1
{
	speed 3 FastSpeed 3
}
actor BloodSSlimeSplatterBall4 : BloodSSlimeSplatterBall1
{
	speed 4 FastSpeed 4
}
actor BloodSSlimeSplatterBall5 : BloodSSlimeSplatterBall1
{
	speed 5 FastSpeed 3
}
