//  ********************************************************
//  ***  Monster: Afrit                                  ***
//  ***  By: Nanami                                      ***
//  ***  Modified By: Cobalt and Butcher                 ***
//  ********************************************************
ACTOR Afrit 3120
{ 
	Tag "Afrit"
	Health 800
	Speed 6 Radius 24 Height 80 PainChance 50 Mass 500
//	PainThreshold 5//incompatible with Skulltag
	Meleedamage 10 
	SeeSound "baron/sight"
	PainSound "baron/pain"
	DeathSound "baron/death"
	ActiveSound "baron/active"
	MeleeSound "baron/melee"
	Missiletype "AfritBall"
	MissileHeight 44
	REACTIONTIME 8
	MONSTER
	//+NORADIUSDMG
	+NOGRAVITY +FLOAT +NOBLOOD
	Obituary "%o was scorched by an Afrit" 
	HitObituary "%o found the Afrit too hot to handle." 
	DropItem Darkmana
	States 
	{ 
	Spawn:
		FRIT ABCD 4 Bright A_Look 
		Loop
	See:
		FRIT A 0 A_CustomMissile("OrbitComet", 44, 0, 0)
		FRIT A 0 A_CustomMissile("OrbitComet2", 44, 0, 180)
		FRIT AABBCCDD 2 Bright A_Chase 
		Goto See +2
	Melee:
		FRIT S 0 A_Jump(64,4)
		FRIT ST 6 Bright A_FaceTarget
		FRIT U 6 Bright A_ComboAttack
		Goto See +2
		FRIT E 6 Bright A_FaceTarget
		FRIT F 6 Bright A_CustomMissile("HellFire", 44, 0, 0)
		FRIT G 6 Bright A_FaceTarget
		Goto See +2
	Missile:
		FRIT S 0 A_Jump(64,8)
		FRIT S 0 A_Jump(128,4)
		FRIT ST 6 Bright A_FaceTarget
		FRIT U 6 Bright A_ComboAttack
		Goto See +2
		FRIT EF 6 Bright A_FaceTarget
		FRIT G 6 Bright A_CustomMissile("Comet", 44, 0, 0)
		Goto See +2
		FRIT E 6 Bright A_FaceTarget
		FRIT F 6 Bright A_CustomMissile("HellFire", 44, 0, 0)
		FRIT G 6 Bright A_FaceTarget
		Goto See +2
	Pain: 
		FRIT HH 4 Bright A_Pain 
		Goto See +2
	Death: 
		NULL A 0 A_KillMaster
		FRIT I 0 Bright A_NoGravity
		FRIT I 6 Bright A_Scream
		FRIT J 5 Bright A_NoBlocking
		FRIT KLMNOPQR 4 Bright
		Stop 
	} 
}
//  ********** Comet medium **********
//  Afrit
actor Comet // :
{
	+FIREDAMAGE
	Radius 6 Height 8 Speed 10
	Damage 5
	ExplosionDamage 40
	ExplosionRadius 80
	Scale .55
	PROJECTILE
	SeeSound "comet/launch"
	DeathSound "comet/explosion"
	MissileType CometTail
	MissileHeight 0
	States
	{
	Spawn:
		COMT AAAABBBBCCCC 1 Bright A_MissileAttack
		Loop
	Death:
		COMT D 3 Bright A_CustomMissile("CometDeathGlow", 0, 0, 0)
		COMT E 3 Bright 
		COMT E 0 A_CustomMissile("CometDeath", 0, 0, 0)
		Stop
	}
}
//  ********** CometTail **********
//  ********** In use by: ******************************
//  Afrit
//  Comet
actor CometTail // :
{
	PROJECTILE
	RENDERSTYLE ADD
	+NOCLIP
	ALPHA 0.4
	States
	{
	Spawn:
		FRTB ABCDEFGHI 1 Bright
		Stop
	}
}
//  ********** CometTail **********
//  ********** In use by: ******************************
//  Afrit
//  OrbitComet
actor OrbitCometTail : CometTail
{
	Scale 0.5
}
//  ********** CometDeath **********
//  Afrit, ~PyroDemon~
//  Comet, FallingComet, OrbitComet
actor CometDeath
{
	PROJECTILE
	RENDERSTYLE ADD
	+NOCLIP
	ALPHA 0.7
	States
	{
	Spawn:
		COMT FGHI 3 Bright
		Stop
	}
}
//  ********** CometDeathGlow **********
//  Afrit, ~PyroDemon~
actor CometDeathGlow : CometTail
{
	Scale 2.0
	Alpha 0.6
	States
	{
	Spawn:
		FRTB ABCDEFGHI 3 Bright
		Stop
	}
}
//  **********  **********
//  Afrit
//  OrbitComet2
actor OrbitComet : Comet
{
	SeeSound ""
	+NOCLIP
	Scale .28
	Speed 5
	MissileType OrbitCometTail
	MissileHeight 0
	States
	{
	Spawn:
		COMT AABBCC 1 Bright A_MissileAttack
		COMT A 0 A_CustomMissile("OrbitComet", 0, 0, 75)
		COMT A 0 A_MissileAttack
		Stop
	}
}
//  ********** OrbitComet2 **********
//  Afrit
actor OrbitComet2 : OrbitComet
{
	MissileType OrbitCometTail
	MissileHeight 0
	States
	{
	Spawn:
		COMT AABBCC 1 Bright A_MissileAttack
		COMT A 0 A_CustomMissile("OrbitComet2", 0, 0, -75)
		COMT A 0 A_MissileAttack
		Stop
	}
}
//  ********** Fireball medium/small **********
//  Afrit
actor AfritBall // :
{
	+FIREDAMAGE
	Radius 6 Height 8 Speed 15
	Damage 8
	PROJECTILE
	RENDERSTYLE ADD
	ALPHA 0.8
	SeeSound "imp/attack"
	DeathSound "imp/shotx"
	States
	{
	Spawn:
		FRTM AB 5 Bright
		Loop
	Death:
		FRTM CDE 6 Bright
		Stop
	}
}
//  ********** FloorFire medium/small **********
//  Afrit
ACTOR HellFire
{
	+FIREDAMAGE +NOBLOCKMAP +MISSILE +DROPOFF
	Speed 5
	Damage 0
	DeathSound "dragonfam/attack"
	States
	{
	Spawn:
		NULL A 1
		Loop
	Death:
		NULL A 0 Bright A_CustomMissile("HellFire1", 0, 0, -180)
		NULL A 0 Bright A_CustomMissile("HellFire1", 0, 16, -175)
		NULL A 0 Bright A_CustomMissile("HellFire1", 0, 32, -170)
		NULL A 0 Bright A_CustomMissile("HellFire1", 0, -16, -185)
		NULL A 0 Bright A_CustomMissile("HellFire1", 0, -32, -190)
		Stop
	}
}
ACTOR HellFire1
{
	+FIREDAMAGE +NOCLIP +MISSILE +DROPOFF
	Speed 2
	Damage 0
	ExplosionDamage 1
	ExplosionRadius 32
	States
	{
	Spawn:
		NULL A 10 //  A_Explode
		NULL A 10 A_CustomMissile("HellFire2", 0, 0, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, 16, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, -16, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, 0, 0)
		NULL A 10 A_Explode
		NULL A 10 A_CustomMissile("HellFire2", 0, 16, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, -16, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, 0, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, 16, 0)
		NULL A 10 //  A_Explode
		NULL A 10 A_CustomMissile("HellFire2", 0, -16, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, 0, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, 16, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, -16, 0)
		NULL A 10 A_Explode
		NULL A 10 A_CustomMissile("HellFire2", 0, 0, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, 16, 0)
		NULL A 10 A_CustomMissile("HellFire2", 0, -16, 0)
		Stop
	}
}
ACTOR HellFire2
{
	+FIREDAMAGE +NOCLIP +MISSILE +DROPOFF +RANDOMIZE
	Scale 1.5
	Speed 0
	Damage 0
	RENDERSTYLE ADD
	ALPHA 0.67
	ExplosionDamage 1
	ExplosionRadius 32
	DeathSound "dragonfam/attack"
	States
	{
	Spawn:
		NULL A 8 //  A_Explode
		FRTF ABC 3 Bright
		FRTF C 0 A_Explode
		FRTF C 0 A_Jump(191,4)
		FRTF C 0 A_CustomMissile("HellFire2", 0, 24, 0)
		FRTF C 0 A_CustomMissile("HellFire2", 0, 0, 0)
		FRTF C 0 A_CustomMissile("HellFire2", 0, -24, 0)
		FRTF DEF 3 Bright
		FRTF F 0 //  A_Explode
		FRTF GHI 3 Bright
		FRTF I 0 //  A_Explode
		FRTF JKL 3 Bright
		FRTF L 0 A_Explode
		FRTF MNO 3 Bright
		Stop
	}
}
