
# How to contribute

One of the easiest ways to contribute is to participate in discussions on GitHub issues. You can also contribute by submitting pull requests with code changes.

## General feedback and discussions?

Start a discussion on the [issue tracker](https://github.com/Brutal-Doom/Brutal-Doom/issues).


## Found a bug, or want to propose a feature/change?

Start a discussion on the [issue tracker](https://github.com/Brutal-Doom/Brutal-Doom/issues). To avoid duplicate issues we ask you to search for an existing issue listing your topic and possibly upvote it to add attention (👍). We would appreciate it if you contribute to the issue with your own comment so that we can consider your own experience or requirements related to that issue.

## Creating an issue regarding a feature/change
**Before posting, ensure the following requirements are met regarding your issue**:
- Your posted suggestion should be about a genuine new feature or change and should not represent something that is a waste of time for developers to read and/or respond to.
- Your suggestion should be a reasonable addition to add to Brutal Doom and should not be considered unrelated or not suitable.
- If possible, try to only suggest something that is possible in both Zandronum and/or GZDoom.

_To avoid spam we enforce these rules and remove the ability to post to those who misuse it._

## Creating an issue regarding a bug
**Before posting, ensure the following requirements are met regarding your issue**:
* Ensure you run the latest version of GZDoom or Zandronum.
* Make sure the bug **ONLY** appears with just Brutal Doom loaded. Any bugs with addons are automatically rejected, even if it is possibly related to Brutal Doom.
* Delta Touch is **not supported**. Any bugs posted when you used Delta Touch is ignored.
* Make sure you use the latest version of Brutal Doom. The latest release is found in the releases channel.
* Please report screenshots and methods to replicate (if applicable) so debugging is easier.

## Creating a pull request
Coding styles and guidelines can be found in [coding guidelines](docs/coding-guidelines.md).
Detailed information about steps taken when setting up a pull request can be found in [pull request guidelines](docs/pull-request-guidelines.md).