# Advanced Coop Bots

Advanced bots for cooperative game modes in Zandronum.

Status: Alpha

## Features

- Real player bots
- Dynamically-spawned navigation nodes
- Real-time node score updating system
- Bots can navigate the map through nodes or follow players
- Bots can pick up items from the ground and use inventory items
- Bots can press use, jump and crouch as needed
- Intelligent weapon selection and firing logic
- Bots can teleport to active players
- Autobot system that fills missing players with bots
- Let players manage bots with `callvote`
- Players can give bots orders via chat

## Supported Games/Mods

- Doom 1/2
- Bring Your Own Class (BYOC) V2.0
  - Artificer
  - Basinga
  - Doomguy
  - Gumboald
  - Heavy
  - Homer
  - Leclerc
  - Megaman Sprite
  - Pizza Tower Guy
  - Postal Dude
  - Revenant
  - Serious Sam 4
  - Stupid Rat
  - Telos
  - Trollface
  - Yung Venuz
- Brutal Doom V21 (weapons and items only)
- Complex Doom V27
- Real Guns Advanced 2: Refined 154

## Usage

Start a cooperative, survival or invasion game and type `addbot` in the console.

On online servers, players can use `callvote addbot "classname"` or `callvote removebot` to manage bots.
Set `classname` to empty (`""`) to add a random bot.

For best results, set the following server variables accordingly:
- `sv_shootthroughallies` and `sv_dontpushallies`: Set to the correct setting if the gameplay mod supports firing through allies.
- `sv_jump`: Set to 2 explicitly if the server or mapset allows jumping.

### Bot Orders

You can give bots orders via in-game chat.

The syntax is `acbot <command>`, where `command` can be either:
- `stay`, `wait`, `hold`:
  Ask the bot to stay at the position where the player aims at.
  The bot will still move around and fight monsters in sight.
- `follow`, `come`, `here`:
  Cancel the `stay` order and have the bot follow players again.
- `take`, `grab`:
  Aim at an item on the ground and tell the bot to take it.

If you are only playing with bots (no other human players in-game), you can drop the `acbot` suffix and say `wait` instead of `acbot wait`.

## Configuration

For offline games, type `acbotmenu` in the console to configure acbots.

For server hosts, see `cvarinfo` for the list of tweakable cvars.

## Source

The source code will be available when a stable version is released and ready to be integrated into other mods.
